/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD (MMM yyyy)
**=======================================================================*/

#include "MoveAround.h"


#define EPSILON (float(1E-6))

/*-------------------------------------------------------------------------------------------*/
// Engine initialisation
SO_ENGINE_SOURCE (MoveAround);


/*-------------------------------------------------------------------------------------------*/
// Construction
MoveAround::MoveAround ()
{
  // Engine and fields initialisation
  SO_ENGINE_CONSTRUCTOR (MoveAround);

  SO_ENGINE_ADD_INPUT (position, (0.0, 0.0, 0.0));
  SO_ENGINE_ADD_INPUT (orientation, (SbRotation::identity()));

  SO_ENGINE_ADD_INPUT (azimuth, (0));
  SO_ENGINE_ADD_INPUT (site, (0));
  SO_ENGINE_ADD_INPUT (distance, (0));

  SO_ENGINE_ADD_INPUT (keepOrientation, (FALSE));
  SO_ENGINE_ADD_INPUT (flatOrientation, (FALSE));

  SO_ENGINE_ADD_OUTPUT (outPosition, SoSFVec3f);
  SO_ENGINE_ADD_OUTPUT (outOrientation, SoSFRotation);

}


/*-------------------------------------------------------------------------------------------*/
// Initialisation
void
MoveAround::initClass ()
{
  SO_ENGINE_INIT_CLASS (MoveAround, SoEngine, "Engine");
}

/*-------------------------------------------------------------------------------------------*/
// Initialisation
void
MoveAround::exitClass ()
{
  SO_ENGINE_EXIT_CLASS(MoveAround);
}

/*-------------------------------------------------------------------------------------------*/
// Destructeur
MoveAround::~MoveAround ()
{
}


/*-------------------------------------------------------------------------------------------*/
// Input changing notification
void
MoveAround::inputChanged (SoField* whichField)
{
  if (whichField == &azimuth) {
    if (azimuth.getValue() > M_PI /2) azimuth.setValue (float (M_PI/2.0));
    if (azimuth.getValue() < -M_PI /2) azimuth.setValue (-float (M_PI/2.0));
  }
  if (whichField == &site) {
    while (site.getValue() > M_PI) site.setValue ((float)(site.getValue() - (2*M_PI)));
    while (site.getValue() < M_PI) site.setValue ((float)(site.getValue() + (2*M_PI)));
  }
  if (whichField == &distance) {
    if (distance.getValue() < EPSILON) distance.setValue (EPSILON);
  }
}


/*-------------------------------------------------------------------------------------------*/
// Computation of output fields
void
MoveAround::evaluate ()
{
  SbRotation rot_site (SbVec3f (0, 1, 0), site.getValue());
  SbRotation rot_azimuth (SbVec3f (1, 0, 0), -azimuth.getValue());
  SbVec3f delta_pos = SbVec3f (0, 0, distance.getValue());

  SbRotation used_rot;

  if (flatOrientation.getValue() == TRUE) {
    SbVec3f V0 (0, 0, -1);
    SbVec3f V1;
    orientation.getValue().multVec (V0, V1);
    SbVec3f V2 (V1[0], 0, V1[2]);
    used_rot = SbRotation (V0, V2);
  }
  else {
    used_rot = orientation.getValue();
  }

  SbVec3f tmp1;
  SbVec3f tmp2;
  rot_azimuth.multVec (delta_pos, tmp1);
  rot_site.multVec (tmp1, tmp2);

  used_rot.multVec (tmp2, delta_pos);

  SbVec3f new_pos = position.getValue() + delta_pos;

  SbRotation final_rot =  rot_azimuth * rot_site * used_rot;

  // Update fields
  SO_ENGINE_OUTPUT (outPosition, SoSFVec3f, setValue(new_pos));
  if (keepOrientation.getValue() == TRUE) {
    SO_ENGINE_OUTPUT (outOrientation, SoSFRotation, setValue(used_rot));
  }
  else {
    SO_ENGINE_OUTPUT (outOrientation, SoSFRotation, setValue(final_rot));
  }
}


