/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

/*==============================================================================
*   Classes     : MoveAround
*   Author(s)   : Fabien ARNAUD
*   Date        : Sept 9 2002
*==============================================================================
*
* Description : This engine takes a position and an orientation as input and
* output a modified position and orientation which is a computed by moving the
* point with a site and an asimuth angle. the keepOrientation flag allow to
* modify only the position, and the flatOrientation flag only use the part of
* the orientation which is in the XZ plane.
*
*============================================================================*/

#ifndef _MOVE_AROUND_H_
#define _MOVE_AROUND_H_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/fields/SoMFVec3f.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoMFBool.h>
#include <Inventor/fields/SoSFRotation.h>
#include <Inventor/fields/SoMFRotation.h>
#include <Inventor/nodes/SoCoordinate3.h>

class MoveAround : public SoEngine {

  SO_ENGINE_HEADER (MoveAround);

public:

  // Constructor
  MoveAround();

  // Inventor's engine public members
  static void initClass();
  static void exitClass();

  // Input fields
  SoSFVec3f    position;
  SoSFRotation orientation;

  SoSFFloat    azimuth;
  SoSFFloat    site;
  SoSFFloat    distance; 

  SoSFBool     keepOrientation;
  SoSFBool     flatOrientation;

  // Output fields
  SoEngineOutput  outPosition;      // (SoSFVec3f) position_out
  SoEngineOutput  outOrientation;   // (SoSFRotation) orientation_out

private:

  // Destructor
  ~MoveAround();

  // Inventor's engine private functions
  virtual void evaluate ();
  virtual void inputChanged (SoField* whichField);
};

#endif  // _MOVE_AROUND_H_

