/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD (MMM yyyy)
**=======================================================================*/

#ifndef _Q_LMV_ADAPTIVE_VIEWING_H_
#define _Q_LMV_ADAPTIVE_VIEWING_H_

#include <Inventor/Qt/OivQtCompat.h>

#include <QDialog>
#include <QLabel>
#include <QCheckBox>

class QWidget;
class QCheckBox;
class QSlider;
class QLabel;
class QSpinBox;
class QRadioButton;
class SoQtViewer;


////////////////////////////////////////////////////////////////////////
class QLmvAdaptiveViewing : public QDialog
{
  Q_OBJECT

public:
  QLmvAdaptiveViewing (QWidget* parent); 
  void setViewer (SoQtViewer*);

private:
  QWidget* m_frame;
  QRadioButton* m_normalRButton;
  QRadioButton* m_numOfTrianglesRButton;
  QSpinBox* m_numOfTrianglesSpinBox;
  QRadioButton* m_fpsRButton;
  QSlider* m_fpsSlider;
  QLabel* m_fpsLabel;
  QRadioButton* m_percentageRButton;
  QSlider* m_percentageSlider;
  QLabel* m_percentageLabel;
  QCheckBox* m_renderWhenStillCheckBox;

  SoQtViewer* m_viewer;

private Q_SLOTS:
  void onNormalToggled (bool);
  void onNumOfTrianglesToggled (bool);
  void onFpsToggled (bool);
  void onPercentageToggled (bool);
  void onRenderWhenStillToggled (bool);
  void onFpsValueChanged (int);
  void onPercentageValueChanged (int);
  void onNumOfTrianglesValueChanged (int);
};


#endif // _Q_LMV_ADAPTIVE_VIEWING_H_


