/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD (MMM yyyy)
**=======================================================================*/
#include <QtCore/qglobal.h>
#include <Inventor/Qt/OivQtCompat.h>

#include "QLmv.h"

#include <Inventor/Qt/SoQtExtEventApplication.h>
#include <Inventor/Qt/SbQtHelper.h>
#include <Inventor/nodes/SoWWWInline.h>



int main( int argc, char* argv[] )
{
  // Search for command lines instructions
  char* configFileName = NULL;
  char* sceneFileName = NULL;
  //char* trackToFollowString = NULL;

#ifdef __APPLE__
  if (argc>1 && argv[1][0] == '-' && argv[1][1] == 'p' && argv[1][2] == 's' && argv[1][3] == 'n')
    argc--;
#endif
  
  for (int i=1; i<argc; i++) {
    if (strlen(argv[i]) > 2) {
      if ((argv[i][0] == '-') && (argv[i][1] == 'P')) {
        configFileName = &(argv[i][2]);
      }
      else {
        sceneFileName = argv[i];
      }
    }
  }
    
  // Create the application
  SbQtHelper::addPlatformPluginsPath();

  SoQtExtEventApplication app(argc, argv );

  QLmv* mainWindow = new QLmv(configFileName);
  mainWindow->activateWindow();
  
  SoWWWInline::setReadAsSoFile(TRUE);
  
  mainWindow->show();
  
  if (sceneFileName != NULL) {
    mainWindow->openFile(sceneFileName);
  }

  // Execute the application
  int result = app.exec();

  // Housekeeping
  delete mainWindow;

  // Returnt the result of the exec.
  return result;
}


