/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/



#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Qt/SoQt.h>
#include <Inventor/Qt/viewers/SoQtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>


/////////////////////////////////////////////////////////////
// CODE FOR The Inventor Mentor STARTS HERE

SoSeparator*
readFile( const SbString& filename )
{
  // Open the input file
  SoInput mySceneInput;
  if ( !mySceneInput.openFile(filename) ) 
  {
    fprintf( stderr, "Cannot open file %s\n", filename.toLatin1() );
    return NULL;
  }
  
  // Read the whole file into the database
  SoSeparator* myGraph = SoDB::readAll( &mySceneInput );
  if ( myGraph == NULL ) 
  {
    fprintf(stderr, "Problem reading file\n");
    return NULL;
  } 
  
  mySceneInput.closeFile();
  return myGraph;
}

// CODE FOR The Inventor Mentor ENDS HERE 
/////////////////////////////////////////////////////////////

int
main( int, char* *argv )
{
  // Need this line to specify that Qt have to share OpenGL contexts on multi windows
  QCoreApplication::setAttribute( Qt::AA_ShareOpenGLContexts );

  // Initialize Inventor and Xt
  QWidget* myWindow = SoQt::init( argv[0] );
  
  // Read the file
  SoSeparator* scene = readFile( "$OIVHOME/data/models/household/plant.iv" );
  scene->ref();

  // Default layout ia a HBoxLayout. Delete it and replace by a grid layout.
  delete myWindow->layout();
  QGridLayout* grid = new QGridLayout(myWindow);

  // Create a viewer
  SoQtExaminerViewer* myViewer = new SoQtExaminerViewer( myWindow );
  
  // attach and show viewer
  myViewer->setSceneGraph( scene );
  myViewer->setTitle( "File Reader (Qt) - Main Viewer" );

  SoQtExaminerViewer* myViewer1 = new SoQtExaminerViewer( myWindow );
  myViewer1->setSceneGraph( scene );
  myViewer1->setTitle( "File Reader (Qt) - Viewer 1" );

  SoQtExaminerViewer* myViewer2 = new SoQtExaminerViewer( myWindow );
  myViewer2->setSceneGraph( scene );
  myViewer2->setTitle( "File Reader (Qt) - Viewer 2" );

  SoQtExaminerViewer* myViewer3 = new SoQtExaminerViewer( myWindow );
  myViewer3->setSceneGraph( scene );
  myViewer3->setTitle( "File Reader (Qt) - Viewer 3" );

  grid->addWidget( myViewer->getWidget(), 0, 0, 1, 1 );
  grid->addWidget( myViewer1->getWidget(), 1, 0, 1, 1 );
  grid->addWidget( myViewer2->getWidget(), 0, 1, 1, 1 );
  grid->addWidget( myViewer3->getWidget(), 1, 1, 1, 1 );

  SoQtExaminerViewer* myViewer4 = new SoQtExaminerViewer( myWindow, "", false );
  myViewer4->setSceneGraph( scene );
  myViewer4->setTitle( "File Reader (Qt) - Viewer 3" );
  myViewer4->show();
  QApplication::processEvents();

  // Loop forever
  SoQt::show( myWindow );
  SoQt::mainLoop();

  scene->unref();
  SoQt::finish();

  return 0;
}

