/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD & Romain BERTHON (MMM YYYY)
** Modified by : Tristan Mehamli (MMM YYYY)
**=======================================================================*/

/***************************************************************************
* QtTView.cxx
* Description
*      Simple application example using Qt.
*      This example displays an Open Inventor or VRML scene graph
*      with tree view using QtListView.
*      It shows how to :
*      - use a split window with SoQt viewer widgets
*      - use different kind of viewers and render area
*      - export images print using Open Inventor offscreen rendering 
*        and Qt printing classes
*      - catch keyboard events in the viewer and write a scene to file 
*      - use clipboard to copy/paste Open Inventor scene graph
*      - handle drag & drop
*      - display a textured backround
*
****************************************************************************/

#include <QApplication>

#include "QtTViewMainFrame.h"
#include "QtTViewViewer.h"

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/Qt/SbQtHelper.h>



void initScene(QtTViewMainFrame*);

int main( int argc, char **argv )
{

  SbQtHelper::addPlatformPluginsPath();

  QApplication qtApplication( argc, argv );
#ifdef __APPLE__
  // Needs to be dynamically allocated
  QtTViewMainFrame* mainFrame = new QtTViewMainFrame;
  mainFrame->activateWindow();
        
  mainFrame->show();
        
  initScene( mainFrame );
#else
  QtTViewMainFrame mainFrame;
  mainFrame.activateWindow();

  mainFrame.show();

  initScene(&mainFrame);
#endif
  
  return qtApplication.exec();
}

void initScene(QtTViewMainFrame *frame) 
{
  SoSeparator *root = new SoSeparator();
  root->addChild(new SoDirectionalLight());

  SoMaterial *mat = new SoMaterial();
  mat->ambientColor.setValue((float)0.00634796,(float)0.047354,(float)0.000659749);
  mat->diffuseColor.setValue((float)0.024884,(float)0.185628,(float)0.00258622);
  mat->specularColor.setValue((float)0.505305,(float)0.463899,(float)0);
  mat->emissiveColor.setValue((float)0,(float)0,(float)0);
  mat->shininess.setValue((float)0.127551);
  root->addChild(mat);

  SoText3 *text = new SoText3();
  text->string.set1Value(0,"Open Inventor suite");
  text->string.set1Value(1,"by VSG");
  text->string.set1Value(2,"with Nokia Qt GUI");
  text->parts = SoText3::ALL;
  text->justification = SoText3::CENTER;
  root->addChild(text);

  frame->m_pGraphicWindow->setScene((SoNode*)root);
}

