/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD & Romain BERTHON (MMM YYYY)
** Modified by : Tristan Mehamli (MMM YYYY)
**=======================================================================*/

#include <QMenuBar>
#include <QSplitter>
#include <QMenu>
#include <QFileDialog>

#include "QtTViewMainFrame.h"
#include "QtTViewTreeView.h"
#include "QtTViewViewer.h"

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/nodes/SoGroup.h>

#include <Inventor/Qt/viewers/SoQtFlyViewer.h>
#include <Inventor/Qt/viewers/SoQtWalkViewer.h>
#include <Inventor/Qt/viewers/SoQtPlaneViewer.h>

QtTViewMainFrame::QtTViewMainFrame( QWidget* parent,const char* name ) 
: QMainWindow( parent,
               Qt::WindowMinMaxButtonsHint |
               Qt::WindowTitleHint | 
               Qt::WindowSystemMenuHint )
{
  // Make initializations
  SoQt::init( this );

  setObjectName( name );

  setWindowTitle( "Open Inventor with Qt" );
  QSplitter* splitter = new QSplitter( this );
  setCentralWidget( splitter );
  
  m_pGraphicWindow = new QtTViewViewer( splitter, "QtTView" );
  m_pGraphicWindow->resize( 400, 400 );

  m_pTreeWindow = new QtTViewTreeView( splitter );
  m_pGraphicWindow->setTreeView( m_pTreeWindow );
  
  QMenuBar* menuBar = new QMenuBar( this );
  QMenu* fileMenu = new QMenu( this );       
  fileMenu->addAction( "New",  this, SLOT(newFile()) );
  fileMenu->addAction( "Open...",  this, SLOT(openFile()) );
  fileMenu->addSeparator();
  fileMenu->addAction( "Export Image...",this, SLOT(printFile()) );
  fileMenu->addAction( "Print...",this, SLOT(printQt()) );
  fileMenu->addSeparator();
  fileMenu->addAction( "Quit", this, SLOT(exitApp()) );
  fileMenu->setTitle( "File" );
  menuBar->addMenu( fileMenu );
  QMenu* editmenu = new QMenu( this );
  editmenu->addAction( "Cut",  this, SLOT(cut()) );
  editmenu->addAction( "Copy",  this, SLOT(copy()) );
  editmenu->addAction( "Paste",  this, SLOT(paste()) );
  editmenu->setTitle( "Edit" );
  menuBar->addMenu( editmenu );
  setMenuBar( menuBar );

  resize( 650, 420 );
  setMinimumSize( 0, 0 );
  setMaximumSize( 32767, 32767 );
}

QtTViewMainFrame::~QtTViewMainFrame()
{
}

void QtTViewMainFrame::exitApp()
{
  exit( 0 );
}

void QtTViewMainFrame::openFile()
{
  QString result = QFileDialog::getOpenFileName( this, "Load file", QString(), "*.iv" );

  if (!result.isEmpty()) 
  {
    SoInput input;
    input.openFile( SbString().fromUtf16( result.utf16() ) );

    SbString dir = SbFileHelper::getDirName( input.getCurStringFileName() );

    if (!dir.isEmpty())
    {
      SoInput::removeDirectory(dir);
      SoInput::addDirectoryLast(dir);
    }

    SoSeparator *root = SoDB::readAll( &input );
    input.closeFile();
    
    if ( root ) 
      m_pGraphicWindow->setScene( (SoNode*)root );
  } 
}

void QtTViewMainFrame::newFile() 
{
  m_pGraphicWindow->setScene( (SoNode*)NULL );
}

void QtTViewMainFrame::printFile()
{
  m_pGraphicWindow->printFile();
}

void QtTViewMainFrame::printQt()
{
  m_pGraphicWindow->printQt();
}

void QtTViewMainFrame::cut() 
{
  m_pGraphicWindow->cut();
}

void QtTViewMainFrame::copy() 
{
  m_pGraphicWindow->copy();
}

void QtTViewMainFrame::paste() 
{
  m_pGraphicWindow->paste();
}


