/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD & Romain BERTHON (MMM YYYY)
** Modified by : Tristan Mehamli (MMM YYYY)
**=======================================================================*/

#include "QtTViewTreeView.h"
#include "QtTViewViewer.h"

#include <QtCore/QStringList>
#include <QHeaderView>

#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/SoType.h>

QtTViewTreeView::QtTViewTreeView( QWidget* parent, const char* name ) 
: QTreeWidget( parent )
{
  setObjectName( name );
  setRootIsDecorated( true );
  
  /* Uncomment this to see the column names in the tree view.
  setColumnCount( 3 );
  QStringList columns;
  columns << "Class" << "Name" << "Pointer";
  setHeaderLabels( columns );
  */
  header()->hide();

  connect( this, SIGNAL(itemActivated(QTreeWidgetItem*, int)), SLOT(selectChange(QTreeWidgetItem*, int)) );
}

QtTViewTreeView::~QtTViewTreeView()
{
}

void 
QtTViewTreeView::selectChange( QTreeWidgetItem* item, int column )
{
    if ( item && (column == 0) ) 
    m_pGraphicWindow->highlightPath( item );
}

void 
QtTViewTreeView::initTree( SoNode* node ) 
{
  clear();

  if ( node ) 
    buildTree( node, NULL );
}

void 
QtTViewTreeView::buildTree( SoNode* node, QTreeWidgetItem* item ) 
{
  SoType nodeType = node->getTypeId();
  const char *nodeClass = nodeType.getName().getString(); 
  const char *nodeName = node->getName().getString();
  QString pointer = QString::number( (uintptr_t)node );

  QTreeWidgetItem* newItem;


  if ( !item ) 
  {
    newItem = topLevelItem( 0 );
    if ( newItem ) 
    {
      for ( int i = 1; i<newItem->childCount(); i++ ) 
        newItem = newItem->child( i );
    }
    newItem = new QTreeWidgetItem( this );
  }
  else 
  {
    newItem = item->child( 0 );
    if ( newItem ) 
    {
      for ( int i = 1; i<newItem->childCount(); i++ ) 
        newItem = newItem->child( i );
    }
    newItem = new QTreeWidgetItem( item );
  }
  newItem->setText( 0, nodeClass );
  newItem->setText( 1, nodeName );
  newItem->setText( 2, pointer );

  if ( nodeType.isDerivedFrom(SoGroup::getClassTypeId()) ) 
  {
    SoGroup* group = (SoGroup*)node;
    for ( int i = 0; i < group->getNumChildren(); i++ )
      buildTree( group->getChild(i), newItem );
  }
}


