/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD & Romain BERTHON (MMM YYYY)
** Modified by : Tristan Mehamli (MMM YYYY)
**=======================================================================*/

#ifndef QtTViewViewer_included
#define QtTViewViewer_included

#include <Inventor/Qt/viewers/SoQtExaminerViewer.h>

#include <QDragEnterEvent>
#include <QDropEvent>
#include <QWidget>

class SoNode;
class SoSelection;
class QtTViewTreeView;
class SoPath;
class QTreeWidgetItem;
class SoVRMLInline;
class SoWWWInline;
class SoSeparator;
class SoTexture2;
class SoVertexProperty;
class QVBoxLayout;

class QtTViewViewer : public QWidget
{
  Q_OBJECT
public:
  void printQt();
  void printFile();
  void highlightPath( QTreeWidgetItem* item );
  QtTViewViewer( QWidget* parent = NULL, const char* name = NULL );
  virtual ~QtTViewViewer();
  void setTreeView( QtTViewTreeView* );
  void setScene( SoNode* );
  void cut();
  void copy();
  void paste();
  SoSeparator* m_pScene2D;
  SoQtFullViewer* m_pViewer;

protected:
  static void  
    WWWInlineFetchURLCB( const SbString& url, void* userdata, SoWWWInline* node );
  static void  
    VRMLInlineFetchURLCB( const SbString& url, void* userdata, SoVRMLInline* node );
  static void* reallocBufCB( void* ptr, size_t newSize );
  static void addSelectPath( void* data, SoPath* path );
  SoPath* getPathFromItem( QTreeWidgetItem* item );
  QTreeWidgetItem* getItemFromPath( SoPath* path );
  void dragEnterEvent( QDragEnterEvent* );
  void dropEvent( QDropEvent* );
  QtTViewTreeView* m_pTreeWindow;
  SoSelection* m_pSelection;

private:
  QVBoxLayout* m_vblayout;
};

#endif // ifndef QtTViewViewer_included


