/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

// Class myVertexShape
//
// Cloned from SoVertexShape
// Only difference is the method getNormalCache is now public so the
// application can retrieve the normals computed by Open Inventor.
//
// NOTE: We will never create an object of this class, only cast the
//       address of a "real" SoVertexShape object to this class so
//       we can access the normal cache.  So the methods are not
//       actually implemented.
//
// Note that the normal cache may not exist for any given primitive.
// It will only exist if Inventor needs to compute normals and the
// primitive has been traversed by a render action.  If the cache
// does not exist, getNormalCache returns NULL.
//
// The normal cache will contain one normal for each vertex of each
// face, regardless of how vertices are shared between faces.


#include <Inventor/caches/SoNormalCache.h>
#include <Inventor/elements/SoCoordinateElement.h>
#include <Inventor/elements/SoCreaseAngleElement.h>
#include <Inventor/elements/SoShapeHintsElement.h>
#include <Inventor/elements/SoDrawStyleElement.h>
#include <Inventor/elements/SoTextureImageElement.h>
#include <Inventor/elements/SoComplexityTypeElement.h>
#include <Inventor/actions/SoGLRenderAction.h>

#if SO_INVENTOR_VERSION < 3000

#include "myVertexShape.h"

SO_NODE_ABSTRACT_SOURCE(myVertexShape)

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: protected

myVertexShape::myVertexShape()
//
////////////////////////////////////////////////////////////////////////
{
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: private

myVertexShape::~myVertexShape()
//
////////////////////////////////////////////////////////////////////////
{
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Subclasses may define this method to generate normals to use
//    when the normal binding is DEFAULT and there aren't enough
//    normals in the state. This should use the given SoNormalBundle
//    to generate the normals. Returns TRUE if normals were generated.
//
//    The default method returns TRUE.
//
// Use: extender, virtual

SbBool
myVertexShape::generateDefaultNormals(SoState *, SoNormalBundle *)
//
////////////////////////////////////////////////////////////////////////
{
    return FALSE;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Sets up a cache to hold normals. This assumes the cache depends
//    on only the current coordinates, shape hints, and crease angle.
//
// Use: protected

void
myVertexShape::setNormalCache(SoState *state,
			      int numNormals, const SbVec3f *normals)
//
////////////////////////////////////////////////////////////////////////
{
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Passes on notification after invalidating any caches.
//
// Use: internal

void
myVertexShape::notify(SoNotList *list)
//
////////////////////////////////////////////////////////////////////////
{
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Returns TRUE if the shape should be rendered now.  Does more then
//    the method in SoShape, because of possible transparency in vertex
//    property node.
//
// Use: protected
//
//////////////////////////////////////////////////////////////////////////
SbBool
myVertexShape::shouldGLRender(SoGLRenderAction *action)
//
////////////////////////////////////////////////////////////////////////
{
  return TRUE;
}

////////////////////////////////////////////////////////////////////////
//
void
myVertexShape::write(SoWriteAction *action)
//
////////////////////////////////////////////////////////////////////////
{
}

#endif /* SO_INVENTOR_VERSION < 3000 */

