/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

// Class myVertexShape
//
// Cloned from SoVertexShape
// Only difference is the method getNormalCache is now public so the
// application can retrieve the normals computed by Open Inventor.
//
// NOTE: We will never create an object of this class, only cast the
//       address of a "real" SoVertexShape object to this class so
//       we can access the normal cache.  So the methods are not
//       actually implemented.
//
// Note that the normal cache may not exist for any given primitive.
// It will only exist if Inventor needs to compute normals and the
// primitive has been traversed by a render action.  If the cache
// does not exist, getNormalCache returns NULL.
//
// The normal cache will contain one normal for each vertex of each
// face, regardless of how vertices are shared between faces.
//

#if SO_INVENTOR_VERSION < 3000

#ifndef  _MY_VERTEX_SHAPE_
#define  _MY_VERTEX_SHAPE_

#include <Inventor/nodes/SoShape.h>
#include <Inventor/nodes/SoVertexProperty.h>
#include <Inventor/fields/SoSFNode.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: myVertexShape
//
//  Abstract vertex-based shape node class. All nodes derived from
//  this class are shapes that are constructed from vertices at some
//  or all of the current coordinates.  They all have vertexProperty nodes,
//  and vpCaches.
//
//////////////////////////////////////////////////////////////////////////////

class SoNormalBundle;
class SoNormalCache;
class SoState;

class myVertexShape : public SoShape {

    SO_NODE_ABSTRACT_HEADER(myVertexShape);
    
  public:
      SoSFNode		vertexProperty;

  SoEXTENDER public:
    // Subclasses may define this method to generate normals to use
    // when the normal binding is DEFAULT and there aren't enough
    // normals in the state. This should use the given SoNormalBundle
    // to generate the normals. Returns TRUE if normals were generated.
    virtual SbBool	generateDefaultNormals(SoState *state,
					       SoNormalBundle *nb);
    virtual void        write(SoWriteAction *writeAction);

  SoINTERNAL public:
    static void		initClass();

    // Redefines this to invalidate normal cache
    virtual void	notify(SoNotList *list);

    // Returns the current normal cache, or NULL if there is none.
    // Note: Before Open Inventor 3.0 this method was protected.
    //       It was moved here to allow applications to access the
    //       normals computed by Open Inventor.
    SoNormalCache	*getNormalCache() const { return normalCache; }

  protected:
    // Constructor - makes this abstract
    myVertexShape();

    virtual ~myVertexShape();
    
    // Returns TRUE if the shape should be rendered. 
    // Checks for transparency in vertexProperty node before invoking
    // render action.
    virtual SbBool	shouldGLRender(SoGLRenderAction *action);
    
    // vpCache stores information from one render to the next about
    // what information needs to be grabbed from the state, etc.
    SoVertexPropertyCache	vpCache;

    // Sets up a cache to hold normals. This assumes the cache depends
    // on only the current coordinates, shape hints, and crease angle.
    void		setNormalCache(SoState *state,
				       int numNormals, const SbVec3f *normals);

  private:
    // This allows instances to cache normals that have been generated
    SoNormalCache	*normalCache;

};

#endif /* _SO_VERTEX_SHAPE_ */

#endif /* SO_INVENTOR_VERSION < 3000 */

