// Open Inventor Example -- Line Segment Editor
// Interactively edit line segments: add new vertices,
// move existing vertices, and/or remove vertices.
//
// Copyright (C) 2003 Template Graphics Software, Inc.
//
// Original: Daniel Lichau 1-Mar-2003
// Modified: 
//
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoPolygonOffset.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include "LineManip.h"

#include <Inventor/SoWinApp.h>

static float
defaultCoords[2][3] =
{
  { -0.2f, 0.0f, 0.0f },
  {  0.2f, 0.0f, 0.0f },
};

int
main(int, char **argv)
{
 // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]);

  LineManip2::initClass(); // don't forget to initialize extension node

  SoSeparator *root = new SoSeparator;

  LineManip2 *manip = new LineManip2;
  manip->setHilightSize(0.01f);

  SoCoordinate3 *coord = manip->getCoordinate3();
  coord->point.setValues(0, 2, defaultCoords);

  root->ref();
  root->addChild(manip);
 
  // Create a viewer
  SoXtPlaneViewer *myViewer = new SoXtPlaneViewer(myWindow);

  // attach and show viewer
  myViewer->setSceneGraph(root);
  myViewer->setTitle("LineManip");
  myViewer->setViewing(FALSE) ;
  myViewer->show();
    
  // Loop forever
  SoXt::show(myWindow);
  SoXt::mainLoop();
  LineManip2::exitClass();
  SoXt::finish();
  return 0;
}

