#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoMaterial.h>

#include <Inventor/helpers/SbFileHelper.h>

#include <Inventor/SoWinApp.h>


int
main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if(myWindow == NULL) 
    exit(1);

  SoSeparator *root = new SoSeparator;
  root->ref();

  SoSeparator *sepCube = new SoSeparator;
  root->addChild(sepCube);

  // Choose a texture 
  // Default mode for texture = MODULATE
  SoTexture2 *rock = new SoTexture2;
  sepCube->addChild(rock);
  rock->filename.setValue(SbFileHelper::expandString("$OIVHOME/examples/source/Inventor/Techniques/TransTexture/sillyFace.rgb"));

  SoMaterial *mat = new SoMaterial;
  mat->diffuseColor.setValue(1.0f, 1.0f, 1.0f);
  mat->transparency.setValue(0.5f);
  sepCube->addChild(mat);

  // Make a cube
  sepCube->addChild(new SoCube);

  SoMaterial *mat2 = new SoMaterial;
  mat2->diffuseColor.setValue(1.0f, 0.0f, 0.0f);
  root->addChild(mat2);

  SoSphere *sphere = new SoSphere;
  sphere->radius = 0.5f;
  root->addChild(sphere);

  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Transparent Texture");
  myViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  // In Inventor 2.1, if the machine does not have hardware texture
  // mapping, we must override the default drawStyle to display textures.
  myViewer->setDrawStyle(SoXtViewer::STILL, SoXtViewer::VIEW_AS_IS);

  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  SoXt::finish();
  return 0;
}


