/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Alain Dumesny (MMM yyyy)
**=======================================================================*/

#ifndef _SO_PIXMAP_BUTTON_
#define _SO_PIXMAP_BUTTON_

#ifdef _WIN32
#  include <windows.h>
#  include <Inventor/Win/SoWinDef.h>
#else // _WIN32
#  include <X11/Intrinsic.h>
#endif // _WIN32

#include <Inventor/SbBasic.h>

class SoWinBitmapButton {
public:
  SoWinBitmapButton(Widget parent, SbBool selectable);

  ~SoWinBitmapButton();
    
  // return the motif push button
  Widget getWidget() { return widget; }
    
#ifdef _WIN32
  // draw the button (called from button parent's wndProc)
  void draw(LPDRAWITEMSTRUCT);

  // specify bitmap id in resource file to use for button
  // (use this instead of the setIcon method)
  // up and down states of button are simulated like Motif.
  void setBitmap(HMODULE hModule, ULONG idBitmap);

  // specify both up and down bitmaps for button
  void setBitmaps(HMODULE hModule,
                  ULONG idUp, ULONG idDown);

  // specify if button will draw differently when it has "focus"
  void showFocus(SbBool);
#else
  // set the icon to use for the pixmap
  voidsetIcon(char *icon, int width, int height);
#endif //_WIN32


  // Highlight the pixmap to show it it selected (must pass TRUE
  // to the constructor, in which case another pixmap with a highlight
  // color will be created for the button).
  void select(SbBool onOrOff);
  SbBool isSelected() { return selectFlag; }
    
private:
  Widget widget;
  SbBool selectFlag, selectable;
  Pixmap normalPixmap, selectPixmap;

#ifdef _WIN32
  // fetch the bitmap(s) from the resource file
  void loadBitmaps();

  ULONG idUp, idDown;
  HMODULE hMod;
  HBITMAP hUpBits;
  HBITMAP hDownBits;

  BITMAP cUpBits;
  BITMAP cDownBits;

  SbBool showsFocus;
#endif //_WIN32
};

#endif // _SO_PIXMAP_BUTTON_


