/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
//
// Class to do word-wrap and simple storage of strings
//
// Note: I think this still has bugs when a word spans an entire line.
//

#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "TextWrapper.h"

//
// Constructor.  This actually does the formatting right away.
//
TextWrapper::TextWrapper(const char *text, int maxLineLength)
{
    assert(text != NULL);

    // Figure out how many paragraphs there are
    n_paragraphs = 0;
    int start = 0; int end = 0;

    while (text[end] != '\0')
    {
	while (text[start] == '\n')
	{
	    ++start; // Skip leading newlines
	}
	
	end = start;
	if (text[start] != '\0')
	{
	    // Search for next newline
	    while (text[end] != '\n' && text[end] != '\0') ++end;
	    ++n_paragraphs;
	    start = end;
	}
    }
    
    // Now allocate and fill in paragraphs

    paragraphs = new Paragraph[n_paragraphs];
    start = end = 0;
    int pnum = 0;

    while (text[end] != '\0')
    {
	while (text[start] == '\n')
	{
	    ++start; // Skip leading newlines
	}
	
	end = start;
	if (text[start] != '\0')
	{
	    // Search for next newline
	    while (text[end] != '\n' && text[end] != '\0') ++end;
	    // And fill in the paragraph
	    WordWrap(paragraphs[pnum], text+start, end-start,
		     maxLineLength);
	    ++pnum;
	    start = end;
	}
    }
}

int
TextWrapper::numParagraphs()
{
    return n_paragraphs;
}

int
TextWrapper::numLines(int whichParagraph)
{
    assert(whichParagraph < n_paragraphs);
    return paragraphs[whichParagraph].n_lines;
}

char *
TextWrapper::getLine(int paragraph, int line)
{
    assert(paragraph < n_paragraphs);
    assert(line < paragraphs[paragraph].n_lines);

    return paragraphs[paragraph].lines[line];
}

//
// Destructor:  frees all storage used
//
TextWrapper::~TextWrapper()
{
    for (int i = 0; i < n_paragraphs; i++)
    {
	for (int j = 0; j < paragraphs[i].n_lines; j++)
	{
	    delete[] paragraphs[i].lines[j];
	}
	delete[] paragraphs[i].lines;
    }
    delete[] paragraphs;
}

void
TextWrapper::WordWrap(Paragraph &p, const char *text, int nchars, int
		      maxLineLength)
{
    int start = 0; int end = 0;

    p.n_lines = 0;

    // First, figure out how many lines there are
    while (end < nchars)
    {
	if (start + maxLineLength < nchars)
	{
	    end = start + maxLineLength;
	    while (text[end] != ' ' && text[end] != '\t' && end >
		   start)
		--end;
	}
	else end = nchars;

	++p.n_lines;

	start = end+1;
    }

    // Allocate and fill in lines
    p.lines = new char *[p.n_lines];
    int linenum = 0; start = end = 0;
    while (end < nchars)
    {
	if (start + maxLineLength < nchars)
	{
	    end = start + maxLineLength;
	    while (text[end] != ' ' && text[end] != '\t' && end >
		   start)
		--end;
	}
	else end = nchars;

	p.lines[linenum] = new char[end-start+1];
	strncpy(p.lines[linenum], text+start, end-start);
	p.lines[linenum][end-start] = '\0';
	++linenum;

	start = end+1;
    }
}

