#include "MainFrame.h"

#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCone.h>

BEGIN_MESSAGE_MAP( MainFrame, CFrameWnd )
ON_WM_CREATE()
END_MESSAGE_MAP()

int
MainFrame::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
  if ( CFrameWnd::OnCreate( lpCreateStruct ) == -1 )
    return -1;

  if ( !m_renderArea.Create( NULL, NULL, AFX_WS_DEFAULT_VIEW, CRect( 0, 0, 0, 0 ), this, AFX_IDW_PANE_FIRST, NULL ) )
    return -1;

  m_renderArea.initializeGL( GetDC()->m_hDC );

  // Create the scene graph to display
  m_rootSceneGraph = new SoSeparator;
  SoPerspectiveCamera* camera = new SoPerspectiveCamera;
  m_rootSceneGraph->addChild( camera );
  m_rootSceneGraph->addChild( new SoDirectionalLight );
  m_rootSceneGraph->addChild( new SoCone );
  camera->viewAll( m_rootSceneGraph.ptr(), SbViewportRegion() );

  // Associate the scene graph and the render area
  m_renderArea.setSceneGraph( m_rootSceneGraph.ptr() );

  return 0;
}

BOOL
MainFrame::PreCreateWindow( CREATESTRUCT& cs )
{
  if ( !CFrameWnd::PreCreateWindow( cs ) )
    return FALSE;

  cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
  cs.lpszClass = AfxRegisterWndClass( 0 );
  cs.cx = 950;
  cs.cy = 650;

  if ( cs.hMenu != NULL )
  {
    ::DestroyMenu( cs.hMenu ); // delete menu if loaded
    cs.hMenu = NULL;           // no menu for this window
  }
  return TRUE;
}
