#include "MainFrame.h"

#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCone.h>

BEGIN_MESSAGE_MAP( MainFrame, CFrameWnd )
  ON_WM_CREATE()
  ON_WM_MOUSEWHEEL()
END_MESSAGE_MAP()

//-----------------------------------------------------------------------------
int
MainFrame::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
  if ( CFrameWnd::OnCreate( lpCreateStruct ) == -1 )
    return -1;

  if ( !m_renderAreaExaminer.Create( NULL, NULL, AFX_WS_DEFAULT_VIEW, CRect( 0, 0, 0, 0 ), this, AFX_IDW_PANE_FIRST, NULL ) )
    return -1;

  m_renderAreaExaminer.initializeGL( GetDC()->m_hDC );

  // Create the scene graph to display
  m_renderAreaExaminer.setSceneGraph( new SoCone );
  m_renderAreaExaminer.viewAll( SbViewportRegion() );

  return 0;
}

//-----------------------------------------------------------------------------
BOOL
MainFrame::PreCreateWindow( CREATESTRUCT& cs )
{
  if ( !CFrameWnd::PreCreateWindow( cs ) )
    return FALSE;

  cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
  cs.lpszClass = AfxRegisterWndClass( 0 );
  cs.cx = 950;
  cs.cy = 650;

  if ( cs.hMenu != NULL )
  {
    ::DestroyMenu( cs.hMenu ); // delete menu if loaded
    cs.hMenu = NULL;           // no menu for this window
  }
  return TRUE;
}

//------------------------------------------------------------------------------
BOOL
MainFrame::OnMouseWheel(UINT flags, short zDelta, CPoint pt)
{
  // We need this code because the child CWnd (m_renderAreaExaminer) can't catch wheel event
  return m_renderAreaExaminer.OnMouseWheel( flags, zDelta, pt );
}

//------------------------------------------------------------------------------
BOOL
MainFrame::PreTranslateMessage( MSG* pMsg )
{
  return m_renderAreaExaminer.PreTranslateMessage(pMsg);
}
