#pragma once

#include <Inventor/ViewerComponents/MFC/StdAfx.h>
#include "StereoPropertiesDialog.h"

/**
 * Derivation of slider control.
 */
class CustomSliderControl : public CSliderCtrl
{
public:
  /**
   * Constructor for slider:
   *  @param name The enum value corresponding to this slider
   *  @param dialog The parent dialog
   *  @param sliderLabel The MFC text label corresponding to the slider's real value
   *  @param realMinValue Minimum real value for this slider
   *  @param realMaxValue Maxumum real value for this slider
   */
  CustomSliderControl( StereoPropertiesDialog::SliderName name, StereoPropertiesDialog* dialog,
                       CStatic* sliderLabel, float realMinValue, float realMaxValue );

  /** Set slider position by real value */
  void setRealValue( float realValue );

  /** Get slider's current real value */
  float getRealValue() const { return m_realValue; }

  /** Update slider's real value based on slider position and min/max real values */
  void updateRealValue();

  /**
   * Set whether or not the slider's corresponding stereo property should be updated
   * at each change of the slider's position or only when the mouse button is released.
   */
  void setContinuousUpdate( bool value ) { m_continuousUpdate = value; }

  /** Returns whether or not the update of the corresponding stereo property should be continuous */
  bool isUpdateContinuous() const { return m_continuousUpdate; }

protected:
  /** Called when the mouse button is released after a slider drag */
  afx_msg void OnLButtonUp( UINT nFlags, CPoint point );

  StereoPropertiesDialog::SliderName m_name; /** Enum value indicating which stereo property is affected by this slider */
  StereoPropertiesDialog* m_dialog;          /** Parent dialog */
  CStatic* m_sliderLabel;                    /** Text label of the slider's real value */
  float m_realMinValue;                      /** Minimum real value */
  float m_realMaxValue;                      /** Maximum real value */
  bool m_continuousUpdate;                   /** Whether or not the update of the corresponding stereo property is continuous */
  float m_realValue;                         /** The current real value of the slider */

  DECLARE_MESSAGE_MAP()
};
