#include "MFCRenderAreaGuiIntegration.h"

#include <Inventor/ViewerComponents/MFC/Viewers/ViewerExaminer.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInteraction.h>

#include <IvTune/SoIvTune.h>

#define MAX_CFileDialog_FILE_COUNT 99
#define FILE_LIST_BUFFER_SIZE ((MAX_CFileDialog_FILE_COUNT * (MAX_PATH + 1)) + 1)

BEGIN_MESSAGE_MAP( MFCRenderAreaGuiIntegration, CWinApp )
  ON_COMMAND( ID_APP_LOADFILE, &MFCRenderAreaGuiIntegration::OnFileOpen )
  ON_COMMAND( ID_APP_IVTUNE, &MFCRenderAreaGuiIntegration::OnIvTune )
  ON_COMMAND( ID_NAVIGATIONMODE_ORBIT, &MFCRenderAreaGuiIntegration::OnOrbitMode )
  ON_COMMAND( ID_NAVIGATIONMODE_PLANE, &MFCRenderAreaGuiIntegration::OnPlaneMode )
  ON_COMMAND( ID_CLIPPINGPLANESMODE_AUTO, &MFCRenderAreaGuiIntegration::OnAutoClippingMode )
  ON_COMMAND( ID_CLIPPINGPLANESMODE_MANUAL, &MFCRenderAreaGuiIntegration::OnManualClippingMode )
  ON_COMMAND( ID_EDIT_RESETVIEW, &MFCRenderAreaGuiIntegration::OnResetView )
  ON_COMMAND( ID_EDIT_YZVIEW, &MFCRenderAreaGuiIntegration::OnYZView )
  ON_COMMAND( ID_EDIT_XZVIEW, &MFCRenderAreaGuiIntegration::OnXZView )
  ON_COMMAND( ID_EDIT_XYVIEW, &MFCRenderAreaGuiIntegration::OnXYView )
  ON_COMMAND( ID_EDIT_SAVECAMERA, &MFCRenderAreaGuiIntegration::OnSaveCamera )
  ON_COMMAND( ID_EDIT_RESTORECAMERA, &MFCRenderAreaGuiIntegration::OnRestoreCamera )
  ON_COMMAND(ID_EDIT_SEEKTOPOINT, &MFCRenderAreaGuiIntegration::OnEditSeektopoint)
  ON_COMMAND(ID_EDIT_STEREO, &MFCRenderAreaGuiIntegration::OnStereo)
  ON_UPDATE_COMMAND_UI(ID_NAVIGATIONMODE_ORBIT, &MFCRenderAreaGuiIntegration::OnUpdateNavigationModeOrbit)
  ON_UPDATE_COMMAND_UI(ID_NAVIGATIONMODE_PLANE, &MFCRenderAreaGuiIntegration::OnUpdateNavigationModePlane)
  ON_UPDATE_COMMAND_UI(ID_CLIPPINGPLANESMODE_AUTO, &MFCRenderAreaGuiIntegration::OnUpdateAutoClippingMode)
  ON_UPDATE_COMMAND_UI(ID_CLIPPINGPLANESMODE_MANUAL, &MFCRenderAreaGuiIntegration::OnUpdateManualClippingMode)
END_MESSAGE_MAP()

MFCRenderAreaGuiIntegration theApp;

MFCRenderAreaGuiIntegration::MFCRenderAreaGuiIntegration()
{
}

BOOL
MFCRenderAreaGuiIntegration::InitInstance()
{
  CWinApp::InitInstance();

  SetRegistryKey( _T("Local AppWizard-Generated Applications") );

  SoDB::init();
  SoInteraction::init();

  ViewerExaminer* pViewerExaminer = new ViewerExaminer;
  if ( !pViewerExaminer )
    return FALSE;
  m_pMainWnd = pViewerExaminer;
  // create and load the frame with its resources
  pViewerExaminer->LoadFrame( IDR_MAINFRAME, WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL, NULL );

  // The one and only window has been initialized, so show and update it
  pViewerExaminer->ShowWindow( SW_SHOW );
  pViewerExaminer->UpdateWindow();

  // This env setting contains the path to OpenInventor
  SbString filepath = SoPreferences::getString( "OIVHOME", "" );
  filepath += "/data/models/chair.iv";

  // Default: We load the default iv file, we use utf16 for 
  // unicode platforms.
  pViewerExaminer->loadFile( filepath );

  return TRUE;
}

int
MFCRenderAreaGuiIntegration::ExitInstance()
{
  // Add OpenInventor finish here
  SoInteraction::finish();
  SoDB::finish();

  return CWinApp::ExitInstance();
}

void
MFCRenderAreaGuiIntegration::runIvTune()
{
  SoIvTune::start( ((ViewerExaminer*)m_pMainWnd)->getChildView()->getSceneGraph() );
}

BOOL
MFCRenderAreaGuiIntegration::OnIdle( LONG lCount )
{
  ::SleepEx( 1, TRUE );
  // "Pause" the application while our app is minimised
  if ( m_pMainWnd->IsIconic() )
    return FALSE;

  return TRUE;
}

void
MFCRenderAreaGuiIntegration::OnFileOpen()
{
  SbString defaultPath = SoPreferences::getString("OIVHOME", "");

  CString fileName;
  LPTSTR p = fileName.GetBuffer(FILE_LIST_BUFFER_SIZE);
  CFileDialog dlgFile(TRUE);
  OPENFILENAME& ofn = dlgFile.GetOFN( );
  ofn.lpstrFile = p;
  ofn.nMaxFile = FILE_LIST_BUFFER_SIZE;

  dlgFile.DoModal();
  fileName.ReleaseBuffer();

  LPTSTR pBufEnd = p + FILE_LIST_BUFFER_SIZE - 2;
  LPTSTR start = p;
  while( ( p < pBufEnd ) && ( *p ) )
    p++;
  if( p > start )
  {
    ( (ViewerExaminer*) m_pMainWnd )->loadFile( start );
    if ( SoIvTune::isRunning() )
    {
      SoIvTune::stop();
      runIvTune();
    }
  }
}

void
MFCRenderAreaGuiIntegration::OnIvTune()
{
  runIvTune();
}

void
MFCRenderAreaGuiIntegration::OnOrbitMode()
{
  ( (ViewerExaminer*) m_pMainWnd )->setNavigationMode( SceneExaminer::ORBIT );
}

void
MFCRenderAreaGuiIntegration::OnPlaneMode()
{
  ( (ViewerExaminer*) m_pMainWnd )->setNavigationMode( SceneExaminer::PLANE );
}

void
MFCRenderAreaGuiIntegration::OnAutoClippingMode()
{
  ( (ViewerExaminer*) m_pMainWnd )->setClippingPlanesAdjustMode( RenderAreaInteractive::AUTO );
}

void
MFCRenderAreaGuiIntegration::OnManualClippingMode()
{
  ( (ViewerExaminer*) m_pMainWnd )->setClippingPlanesAdjustMode( RenderAreaInteractive::MANUAL );
}

void
MFCRenderAreaGuiIntegration::OnResetView()
{
  ( (ViewerExaminer*) m_pMainWnd )->viewAll();
}

void
MFCRenderAreaGuiIntegration::OnYZView()
{
  ( (ViewerExaminer*) m_pMainWnd )->viewAxis( SbVec3f(-1.f, 0.f, 0.f), SbVec3f(0, 0, 1) );
  ( (ViewerExaminer*) m_pMainWnd )->viewAll();
}

void
MFCRenderAreaGuiIntegration::OnXZView()
{
  ( (ViewerExaminer*) m_pMainWnd )->viewAxis( SbVec3f(0.f, -1.f, 0.f), SbVec3f(1, 0, 0) );
  ( (ViewerExaminer*) m_pMainWnd )->viewAll();
}

void
MFCRenderAreaGuiIntegration::OnXYView()
{
  ( (ViewerExaminer*) m_pMainWnd )->viewAxis( SbVec3f(0.f, 0.f, -1.f), SbVec3f(0, 1, 0) );
  ( (ViewerExaminer*) m_pMainWnd )->viewAll();
}

void
MFCRenderAreaGuiIntegration::OnSaveCamera()
{
  ( (ViewerExaminer*) m_pMainWnd )->saveCamera();
}

void
MFCRenderAreaGuiIntegration::OnRestoreCamera()
{
  ( (ViewerExaminer*) m_pMainWnd )->restoreCamera();
}


void MFCRenderAreaGuiIntegration::OnEditSeektopoint()
{
  ( (ViewerExaminer*) m_pMainWnd )->setSeekMode( true );
}

void MFCRenderAreaGuiIntegration::OnStereo()
{
  ((ViewerExaminer*) m_pMainWnd)->openStereoPreferences();
}

void
MFCRenderAreaGuiIntegration::OnUpdateNavigationModeOrbit( CCmdUI *pCmdUI )
{
  pCmdUI->SetCheck( ( (ViewerExaminer*) m_pMainWnd )->getNavigationMode() == SceneExaminer::ORBIT );
}


void
MFCRenderAreaGuiIntegration::OnUpdateNavigationModePlane(CCmdUI *pCmdUI)
{
  pCmdUI->SetCheck( ( (ViewerExaminer*) m_pMainWnd )->getNavigationMode() == SceneExaminer::PLANE );
}

void
MFCRenderAreaGuiIntegration::OnUpdateAutoClippingMode(CCmdUI *pCmdUI)
{
  pCmdUI->SetCheck( ( (ViewerExaminer*) m_pMainWnd )->getClippingPlanesAdjustMode() == RenderAreaInteractive::AUTO );
}

void
MFCRenderAreaGuiIntegration::OnUpdateManualClippingMode(CCmdUI *pCmdUI)
{
  pCmdUI->SetCheck( ( (ViewerExaminer*) m_pMainWnd )->getClippingPlanesAdjustMode() == RenderAreaInteractive::MANUAL );
}
