#ifndef MFCRENDERAREAGUIINTEGRATION_H_
#define MFCRENDERAREAGUIINTEGRATION_H_

#include <Inventor/ViewerComponents/MFC/RenderAreaInteractive.h>

#include "res/Resource.h"

/**
 * This class implement the main application
 */
class MFCRenderAreaGuiIntegration : public CWinApp
{

public:
  MFCRenderAreaGuiIntegration();

  BOOL InitInstance();
  int ExitInstance();

  /**
   * MFC callbacks
   */
  afx_msg BOOL OnIdle( LONG lCount );
  afx_msg void OnFileOpen();
  afx_msg void OnIvTune();
  afx_msg void OnOrbitMode();
  afx_msg void OnPlaneMode();
  afx_msg void OnAutoClippingMode();
  afx_msg void OnManualClippingMode();
  afx_msg void OnResetView();
  afx_msg void OnYZView();
  afx_msg void OnXZView();
  afx_msg void OnXYView();
  afx_msg void OnSaveCamera();
  afx_msg void OnRestoreCamera();
  afx_msg void OnEditSeektopoint();
  afx_msg void OnStereo();

  afx_msg void OnUpdateNavigationModeOrbit( CCmdUI *pCmdUI );
  afx_msg void OnUpdateNavigationModePlane( CCmdUI *pCmdUI );
  afx_msg void OnUpdateAutoClippingMode( CCmdUI *pCmdUI );
  afx_msg void OnUpdateManualClippingMode( CCmdUI *pCmdUI );

protected:

  /**
   * Run IvTune.
   */
  virtual void runIvTune();

  DECLARE_MESSAGE_MAP()
};

extern MFCRenderAreaGuiIntegration theApp;

#endif // MFCRENDERAREAGUIINTEGRATION_H_
