#include "MainFrame.h"
#include "res/Resource.h"

#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/ViewerComponents/SoCameraInteractor.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>
#include <IvTune/SoIvTune.h>

BEGIN_MESSAGE_MAP(MainFrame, CFrameWnd)
  ON_WM_CREATE()
  ON_WM_SETFOCUS()
  ON_WM_MOUSEWHEEL()
END_MESSAGE_MAP()

int MainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
  if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
    return -1;

  if (!m_renderAreaExaminer.Create( NULL, NULL, AFX_WS_DEFAULT_VIEW, CRect( 0, 0, 0, 0 ), this, AFX_IDW_PANE_FIRST, NULL ) )
    return -1;

  if ( !m_stereoDialog.Create( IDD_STEREODIALOG, &m_renderAreaExaminer ) )
    return -1;

  m_renderAreaExaminer.initializeGL( GetDC()->m_hDC, true );

  if ( !isRawStereoAvailable() )
    MessageBox( _T( "Could not enable stereo buffers." ), _T( "Warning" ), MB_ICONWARNING | MB_OK );

  return 0;
}

BOOL MainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
  if( !CFrameWnd::PreCreateWindow(cs) )
    return FALSE;

  cs.cx = 950;
  cs.cy = 650;

  cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
  cs.lpszClass = AfxRegisterWndClass(0);
  return TRUE;
}

//------------------------------------------------------------------------------
void
MainFrame::loadFile( const SbString& filename )
{
  SoInput input;

  // We try to open the file
  if (input.openFile( filename ))
  {
    // We read the content.
    m_sceneGraph = SoDB::readAll( &input );
    m_renderAreaExaminer.setSceneGraph(m_sceneGraph.ptr());
    m_renderAreaExaminer.viewAll(SbViewportRegion());
    if (SoIvTune::isRunning())
    {
      SoIvTune::stop();
      startIvTune();
    }
  }
}

//------------------------------------------------------------------------------
void
MainFrame::startIvTune()
{
  SoIvTune::start(m_sceneGraph.ptr());
}

//------------------------------------------------------------------------------
void
MainFrame::viewAll()
{
  m_renderAreaExaminer.viewAll(SbViewportRegion());
}

void
MainFrame::setNavigationMode( SceneExaminer::NavigationMode mode )
{
  m_renderAreaExaminer.setNavigationMode( mode );
}

SceneExaminer::NavigationMode
MainFrame::getNavigationMode()
{
  return m_renderAreaExaminer.getNavigationMode();
}

RenderAreaInteractive::ClippingPlanesAdjustMode
MainFrame::getClippingPlanesAdjustMode()
{
  return m_renderAreaExaminer.getClippingPlanesAdjustMode();
}

void
MainFrame::setClippingPlanesAdjustMode(RenderAreaInteractive::ClippingPlanesAdjustMode mode)
{
  m_renderAreaExaminer.setClippingPlanesAdjustMode(mode);
}

void
MainFrame::viewAxis(const SbVec3f& direction, const SbVec3f& up)
{
  m_renderAreaExaminer.viewAxis( direction, up );
}

//------------------------------------------------------------------------------
void
MainFrame::saveCamera()
{
  m_renderAreaExaminer.getSceneExaminer()->getCameraInteractor()->pushCamera();
}

//------------------------------------------------------------------------------
void
MainFrame::restoreCamera()
{
  m_renderAreaExaminer.getSceneExaminer()->getCameraInteractor()->popCamera();
}

//------------------------------------------------------------------------------
BOOL
MainFrame::OnMouseWheel(UINT flags, short zDelta, CPoint pt)
{
  // We need this code because the child CWnd (m_renderAreaExaminer) can't catch wheel event
  return m_renderAreaExaminer.OnMouseWheel( flags, zDelta, pt );
}

//------------------------------------------------------------------------------
BOOL
MainFrame::PreTranslateMessage( MSG* pMsg )
{
  return m_renderAreaExaminer.PreTranslateMessage(pMsg);
}

//------------------------------------------------------------------------------
void
MainFrame::setSeekMode( bool onOrOff )
{
  m_renderAreaExaminer.getSceneExaminer()->setSeekMode( onOrOff );
}

void
MainFrame::openStereoPreferences()
{
  if ( !m_renderAreaExaminer.isStereoSupported() || !m_renderAreaExaminer.isRawStereoAvailable() )
  {
    // disable stereo controls if stereo is not supported
    m_stereoDialog.enableControls( false );
  }

  m_stereoDialog.ShowWindow( SW_SHOW );
}

void
MainFrame::activateStereo( bool activated )
{
  m_renderAreaExaminer.activateStereo( activated );
}

bool
MainFrame::isRawStereoAvailable()
{
  return m_renderAreaExaminer.isRawStereoAvailable();
}

bool
MainFrame::isStereoSupported()
{
  return m_renderAreaExaminer.isStereoSupported();
}

void
MainFrame::setStereoCameraOffset( float offset )
{
  m_renderAreaExaminer.setStereoCameraOffset( offset );
}

void
MainFrame::setStereoCameraBalance( float balance )
{
  m_renderAreaExaminer.setStereoCameraBalance( balance );
}
