#ifndef MAINFRAME_H
#define MAINFRAME_H

#include <Inventor/ViewerComponents/MFC/RenderAreaExaminer.h>
#include "StereoPropertiesDialog.h"

/**
 * This class implement the main frame
 */
class MainFrame : public CFrameWnd
{

public:

  virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

  /**
   * Function to get the child view
   */
  RenderAreaExaminer* getChildView()
  {
    return &m_renderAreaExaminer;
  }

  /**
   * Function to load an iv file
   */
  void loadFile( const SbString& filename );

  /**
   * Function to start ivTune viewer
   */
  void startIvTune();

  /**
   * Function to recenter camera on the scene
   */
  void viewAll();

  /**
  * Set navigation mode.
  */
  void setNavigationMode( SceneExaminer::NavigationMode mode );

  /**
  * Returns the current navigation mode.
  */
  SceneExaminer::NavigationMode getNavigationMode();

  /**
   * Get the camera clipping planes adjustment mode.
   */
  RenderAreaInteractive::ClippingPlanesAdjustMode getClippingPlanesAdjustMode();

  /**
  * Set the camera clipping planes adjustment mode.
  */
  virtual void setClippingPlanesAdjustMode(RenderAreaInteractive::ClippingPlanesAdjustMode mode);

  /**
   * Moves the camera to be aligned with the given direction vector while
   * keeping the "up" direction of the camera parallel to the specified up
   * vector.
   */
  void viewAxis( const SbVec3f& direction, const SbVec3f& up );

  /**
   * Function to save the camera parameters
   */
  void saveCamera();

  /**
   * Function to restore the camera parameters
   */
  void restoreCamera();

  /**
   * Set the interaction into or out off seek mode.
   */
  void setSeekMode( bool onOrOff );

  /**
   * Open stereo preferences dialog
   */
  void openStereoPreferences();

  /**
   * Activate/Deactivate stereo.
   */
  void activateStereo( bool activated );

  /**
   * Returns true if stereo buffering is enabled.
   */
  bool isRawStereoAvailable();

  /**
   * Returns true if stereo can be activated.
   */
  bool isStereoSupported();

  /**
   * Set the stereo offset.
   */
  void setStereoCameraOffset( float offset );

  /**
   * Set the stereo balance.
   */
  void setStereoCameraBalance( float balance );

protected:

  RenderAreaExaminer m_renderAreaExaminer;

  StereoPropertiesDialog m_stereoDialog;

  SoRef<SoNode> m_sceneGraph;

  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  afx_msg BOOL OnMouseWheel(UINT flags, short zDelta, CPoint pt);
  afx_msg BOOL PreTranslateMessage(MSG* pMsg);

  DECLARE_MESSAGE_MAP()

};

#endif // MAINFRAME_H
