#include <Inventor/ViewerComponents/Qt/QML/RenderAreaOrbiter.h>

#include <Inventor/ViewerComponents/Qt/QtHelper.h>
#include <Inventor/SoInteraction.h>
#include <Inventor/actions/SoHaloHighlightRenderAction.h>
#include <Inventor/nodes/SoFile.h>
#include <Inventor/nodes/SoSelection.h>

#include <QApplication>
#include <QMainWindow>
#include <QQmlContext>
#include <QQmlEngine>
#include <QQuickWidget>

using namespace openinventor::inventor::viewercomponents::qt::qml;

int
main( int argc, char** argv )
{
  QtHelper::addPlatformPluginsPath();

  // Creates application
  QApplication app( argc, argv );

  SoDB::init();
  SoInteraction::init();

  // Creates the main window and passes it the scene graph
  SoRef<SoSelection> root = new SoSelection; // We use here a SoSelection in order to be able to "pick" the different elements of the scene.
  SoFile* modelFile = new SoFile;
  modelFile->name = "$OIVHOME/data/models/chair.iv";
  root->addChild( modelFile );

  // Redraw scene on selection changed
  root->addStartCallback( []( void* /*data*/, SoSelection* selection )
  {
    selection->touch();
  } );

  QMainWindow* mainWindow = new QMainWindow();

#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
  QQuickWindow::setGraphicsApi(QSGRendererInterface::OpenGL);
  qmlRegisterModule("QtQml.WorkerScript", 2, 7);
#endif
  qmlRegisterType<RenderAreaOrbiter>( "OpenInventorQml", 1, 0, "RenderAreaOrbiter" );
  QQmlEngine* engine = new QQmlEngine( mainWindow );
  engine->addImportPath( QtHelper::qtPluginsPath() );

  engine->rootContext()->setContextProperty( "oiv", mainWindow );
  QQuickWidget* view = new QQuickWidget( engine, mainWindow );
  view->setResizeMode( QQuickWidget::SizeRootObjectToView );
  view->setSource( QUrl( "qrc:/main.qml" ) );
  mainWindow->setCentralWidget( view );
  mainWindow->resize( 1600, 900 );

  QObject* object = view->rootObject();
  RenderAreaOrbiter* renderAreaOrbiter = object->findChild<RenderAreaOrbiter*>( "mainRenderAreaOrbiter" );
  if ( renderAreaOrbiter )
  {
    renderAreaOrbiter->setSceneGraph( root.ptr() );
    renderAreaOrbiter->viewAll( SbViewportRegion() );
    SoGLRenderAction* glrenderAction = new SoHaloHighlightRenderAction;
    renderAreaOrbiter->setGLRenderAction( glrenderAction );
    renderAreaOrbiter->setAntialiasingMode( SoSceneManager::AUTO );
    renderAreaOrbiter->setAntialiasingQuality( 1 );

    mainWindow->show();
    app.exec();

    delete glrenderAction;
  }

  // Frees the memory
  delete mainWindow;
  root = nullptr;
  SoInteraction::finish();
  SoDB::finish();
  return 0;
}
