#include <QApplication>
#include <QGridLayout>
#include <QMainWindow>

#include <Inventor/SoDB.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoDirectionalLight.h>

#include <Inventor/ViewerComponents/Qt/RenderArea.h>
#include <Inventor/ViewerComponents/Qt/QtHelper.h>

int main( int argc, char** argv )
{
  QtHelper::addPlatformPluginsPath();

  QApplication app( argc, argv );

  SoDB::init();

  // We create a main window instance and we display it.
  QMainWindow* window = new QMainWindow;
  
  // create Open Inventor scene graph
  SoRef<SoSeparator> rootSceneGraph = new SoSeparator;
  SoPerspectiveCamera* camera = new SoPerspectiveCamera;
  rootSceneGraph->addChild(camera);
  rootSceneGraph->addChild(new SoDirectionalLight);
  rootSceneGraph->addChild(new SoCone);
  camera->viewAll(rootSceneGraph.ptr(),SbViewportRegion());

  RenderArea* renderArea = new RenderArea(window);
  renderArea->setSceneGraph(rootSceneGraph.ptr());

  window->setCentralWidget(renderArea->getContainerWidget());
  window->resize(949, 614);
  window->show();

  app.exec();

  // We free the memory.
  rootSceneGraph = NULL;
  delete window;

  SoDB::finish();

  return 0;
}


