#include <Inventor/ViewerComponents/Qt/QtHelper.h>
#include <Inventor/ViewerComponents/Qt/RenderAreaExaminer.h>

#include <Inventor/SoDB.h>
#include <Inventor/nodes/SoCone.h>

#include <QApplication>
#include <QGridLayout>
#include <QMainWindow>

int main( int argc, char** argv )
{
  QtHelper::addPlatformPluginsPath();

  QApplication app( argc, argv );

  SoDB::init();

  // We create a main window instance and we display it.
  QMainWindow* window = new QMainWindow;

  // create Open Inventor scene graph
  RenderAreaExaminer* renderArea = new RenderAreaExaminer(window);
  SoRef<SoCone> cone = new SoCone;
  renderArea->setSceneGraph(cone.ptr());
  renderArea->viewAll(SbViewportRegion());

  window->setCentralWidget(renderArea->getContainerWidget());
  window->resize(949, 614);
  window->show();

  app.exec();

  // We free the memory.
  cone = nullptr;
  delete window;
  SoDB::finish();
  return 0;
}


