#ifndef MAIN_WINDOW_H
#define MAIN_WINDOW_H

#include <QMainWindow>

#include <ui_MainWindow.h>
#include <Inventor/ViewerComponents/Qt/Viewers/ViewerExaminer.h>
/**
 * This class adds the events support to the interface designed
 * using Qt designer.
 *
 * All the callbacks from the interface are implemented in this class.
 * It adds the viewer to the interface to, because the QtViewer is not available in
 * Qt designer.
 */
class MainWindow : public QMainWindow, public Ui::MainWindow
{
  Q_OBJECT

public:

  /**
   * Constructor.
   */
  MainWindow( QWidget* parent );

  /**
   * Should application be stopped ?
   */
  static bool applicationShouldStop() { return shouldStop; }

protected:
  /** 
   * This method is called when a drop event occurs.
   */
  virtual void dropEvent( QDropEvent * event );
  virtual void dragEnterEvent( QDragEnterEvent* event );
  virtual void closeEvent( QCloseEvent* event );

protected Q_SLOTS:

  /**
   * File open callback when the user wants to open a file.
   */
  virtual void openFileAction();

  /**
   * Run IvTune.
   */
  virtual void runIvTune();

private:

  // We always keep an instance of the viewer...
  ViewerExaminer* m_viewerExaminer;

  // Closing Main Window makes the application to be stopped.
  static bool shouldStop;
};

#endif // MAIN_WINDOW_H


