#include <MainWindow.h>

#include <Inventor/ViewerComponents/Qt/QtHelper.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInteraction.h>

#include <QApplication>
#include <QGraphicsView>

int main( int argc, char** argv )
{
  QtHelper::addPlatformPluginsPath();

  QApplication app( argc, argv );

  SoDB::init();
  SoInteraction::init();

  // We create a mainwindow instance and we dislpay it.
  MainWindow* window = new MainWindow( nullptr );
  window->show();

  app.exec();

  // We free the memory.
  delete window;

  SoInteraction::finish();
  SoDB::finish();

  return 0;
}


