#include <Inventor/SoDB.h>
#include <Inventor/SoInteraction.h>
#include <Inventor/ViewerComponents/Qt/RenderAreaOrbiter.h>
#include <Inventor/ViewerComponents/Qt/QtHelper.h>
#include <Inventor/actions/SoHaloHighlightRenderAction.h>
#include <Inventor/nodes/SoFile.h>
#include <Inventor/nodes/SoSelection.h>
#include <QApplication>
#include <QMainWindow>

int
main( int argc, char** argv )
{
  QtHelper::addPlatformPluginsPath();

  QApplication app( argc, argv );

  SoDB::init();
  SoInteraction::init();

  QMainWindow *mainWindow = new QMainWindow;

  RenderAreaOrbiter* renderArea = new RenderAreaOrbiter( mainWindow );
  mainWindow->setCentralWidget( renderArea->getContainerWidget() );

  // Scene graph
  SoRef<SoSelection> root = new SoSelection; // We use here a SoSelection in order to be able to "pick" the different elements of the scene.
  SoFile* modelFile = new SoFile;
  modelFile->name = "$OIVHOME/data/models/chair.iv";
  root->addChild( modelFile );

  // Redraw scene on selection changed
  root->addStartCallback( []( void* /*data*/, SoSelection* selection )
  {
    selection->touch();
  } );

  renderArea->setSceneGraph( root.ptr() );
  renderArea->viewAll( SbViewportRegion() );
  SoGLRenderAction* glrenderAction = new SoHaloHighlightRenderAction;
  renderArea->setGLRenderAction( glrenderAction );
  renderArea->setAntialiasingMode( SoSceneManager::AUTO );
  renderArea->setAntialiasingQuality( 1 );

  mainWindow->resize( 1600, 900 );
  mainWindow->show();

  app.exec();

  // We free the memory.
  root = nullptr;
  delete mainWindow;
  delete glrenderAction;

  SoInteraction::finish();
  SoDB::finish();
  return 0;
}
