#include <Inventor/SoDB.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/ViewerComponents/Win/RenderArea.h>

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
  MSG msg;
  BOOL done = FALSE;

  // Init OpenInventor
  SoDB::init();

  // Create the render area
  RenderArea* renderArea = new RenderArea;

  // Initialize openGL window ( window size : 950*650 )
  renderArea->initializeGL( 950, 650 );

  // Create the scene graph to display
  SoRef<SoSeparator> rootSceneGraph = new SoSeparator;
  SoPerspectiveCamera* camera = new SoPerspectiveCamera;
  rootSceneGraph->addChild( camera );
  rootSceneGraph->addChild( new SoDirectionalLight );
  rootSceneGraph->addChild( new SoCone );
  camera->viewAll( rootSceneGraph.ptr(), SbViewportRegion() );

  // Associate the scene graph and the render area
  renderArea->setSceneGraph( rootSceneGraph.ptr() );
  renderArea->paintGL();

  // Main loop
  while ( !done )
  {
    // Check windows messages
    if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
    {
      if ( msg.message == WM_QUIT )
      {
        done = TRUE;
      }
      else
      {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
      }
    }
  }

  // Delete renderArea
  delete renderArea;

  // Clear Open Inventor
  SoDB::finish();

  return (int)( msg.wParam );
}
