#include <Inventor/SoDB.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/ViewerComponents/Win/RenderAreaExaminer.h>

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
  MSG msg;
  BOOL done = FALSE;

  // Init OpenInventor
  SoDB::init();

  // Create the render area
  RenderAreaExaminer* renderArea = new RenderAreaExaminer;

  // Associate the scene graph and the render area
  renderArea->setSceneGraph( new SoCone );
  renderArea->viewAll( SbViewportRegion() );

  // Initialize openGL window ( window size : 950*650 )
  renderArea->initializeGL( 950, 650 );

  // Main loop
  while ( !done )
  {
    // Check windows messages
    if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
    {
      if ( msg.message == WM_QUIT )
      {
        done = TRUE;
      }
      else
      {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
      }
    }
    else
    {
      ::SleepEx(1,TRUE);
    }
  }

  // Delete renderArea
  delete renderArea;

  // Clear Open Inventor
  SoDB::finish();

  return (int)( msg.wParam );
}
