/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : MMH (MMM YYYY)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCone.h>

#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoResetTransform.h>

#include <Inventor/helpers/SbFileHelper.h>

#ifdef WIN32
#pragma warning(push)
#pragma warning( disable:4996 ) // Ignore stdio unsafe warnings
#endif 

////////////////////////////////////////////////////////////////////////

void
main(int argc, char **argv)
{
  SbString filename = SbFileHelper::expandString( "$OIVHOME" ) + "/examples/source/Inventor/BigImageRender/test.iv";
  if (argc > 1)
    filename = argv[1];
  FILE *fp = fopen( filename.toLatin1 (), "r" );
  if (fp == NULL) {
    printf( "Unable to open '%s'\n", filename.toLatin1() );
    filename.makeNull();
  }
  else
    fclose( fp );

  // Initialize Open Inventor
  Widget myWindow = SoXt::init(argv[0]);
  if (myWindow == NULL) exit(1);

  // Root node of scene graph
  // 3D (application) and 2D (annotation) scene graphs below this.
  SoSeparator *pRoot = new SoSeparator();
  pRoot->ref();

  // Try to read the file in 3D Root separator
  SoSeparator *p3dSep = NULL;
  if (! filename.isEmpty() ) {
    SoInput in;
    in.openFile( filename.toLatin1 () );
    p3dSep = SoDB::readAll( &in );
    in.closeFile();
  }

  // If that failed, create our favorite geometry
  if (p3dSep == NULL) {
    SoMaterial  *pMatl = new SoMaterial();
    SoCone      *pCone = new SoCone();

    pMatl->diffuseColor.setValue( 1,0,0 );

    p3dSep = new SoSeparator();
    p3dSep->addChild( pMatl );
    p3dSep->addChild( pCone );
  }

  // Create 3D (usually perspective) camera.
  // We'll add this above the 3D scene root to make it easy to clear out
  // the 3D scene (e.g. removeAllChildren) and add a new one.
  SoPerspectiveCamera *p3dCam = new SoPerspectiveCamera();
  pRoot->addChild( p3dCam );
  pRoot->addChild( p3dSep );

  // Create 2D scene root and camera (usually orthographic)
  SoSeparator *p2dSep   = new SoSeparator();
  SoOrthographicCamera *p2dCam = new SoOrthographicCamera();

  // Font settings and material for 2D annotations
  SoFont *pFont1 = new SoFont();
  pFont1->name = "Arial";
  pFont1->size = 20;
  pFont1->renderStyle = SoFont::TEXTURE;
  SoMaterial *pMatl1 = new SoMaterial();
  pMatl1->diffuseColor = SbColor(1,1,1);

  // Build basic 2D scene
  pRoot->addChild( p2dSep );
  p2dSep->addChild( p2dCam );
  p2dSep->addChild( pFont1 );
  p2dSep->addChild( pMatl1 );

  // Create some 2D annotations
  SoSeparator *pTextSep1 = new SoSeparator();
  SoTranslation *pTran1 = new SoTranslation();
  SoText2 *pText1 = new SoText2();
  pTran1->translation = SbVec3f( -.99f, .9f, 0 );
  pText1->string = "Upper Left";
  pTextSep1->addChild( pTran1 );
  pTextSep1->addChild( pText1 );
  p2dSep->addChild( pTextSep1 );

  SoSeparator *pTextSep2 = new SoSeparator();
  SoTranslation *pTran2 = new SoTranslation();
  SoText2 *pText2 = new SoText2();
  pTran2->translation = SbVec3f( -.99f, -.95f, 0 );
  pText2->string = "Lower Left";
  pTextSep2->addChild( pTran2 );
  pTextSep2->addChild( pText2 );
  p2dSep->addChild( pTextSep2 );

  SoSeparator *pTextSep3 = new SoSeparator();
  SoTranslation *pTran3 = new SoTranslation();
  SoText2 *pText3 = new SoText2();
  pTran3->translation = SbVec3f( .99f, -.95f, 0 );
  pText3->string = "Lower Right";
  pText3->justification = SoText2::RIGHT;
  pTextSep3->addChild( pTran3 );
  pTextSep3->addChild( pText3 );
  p2dSep->addChild( pTextSep3 );

  // Finally... We don't want the extent of the annotations to affect
  // a "viewAll" of the application geometry.  So we'll "reset" the 
  // accumulated bounding box during traveral of the annotation scene.
  SoResetTransform *pResetBbox = new SoResetTransform();
  pResetBbox->whatToReset = SoResetTransform::BBOX;
  p2dSep->addChild( pResetBbox );

  // Create the viewer and set some properties
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setBackgroundColor( SbColor(0,.6f,.6f) );
  myViewer->setTitle( "2D Annotation" );
  myViewer->show();

#if 1
  // Setup for images in Forum posting
  myViewer->setSize( SbVec2s(300,300) );
  myViewer->setDecoration( FALSE );
#endif

  // Load the scene graph and adjust the 3D camera to view entire scene.
  // Have to do this "manually" because we have our own camera.
  // Don't forget to save this as the Home position!
  myViewer->setSceneGraph( pRoot );
  myViewer->viewAll();
  myViewer->saveHomePosition();

  // Loop, then cleanup
  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  pRoot->unref();
  SoXt::finish();
}

#ifdef WIN32
#pragma warning( pop )
#endif
