// Annotation3D Part 1 - Bounding box
//
// Original: MHeck, VSG
// Modified: 

////////////////////////////////////////////////////////////////////////
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoSeparator.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <VolumeViz/nodes/SoTransferFunction.h>

////////////////////////////////////////////////////////////////////////

#include "MakeBBox.h"

////////////////////////////////////////////////////////////////////////
// main function

int main(int, char **argv)
{
  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow) return 0;

  // Initialize VolumeViz
  SoVolumeRendering::init();

  // Load some volume data  
  SoVolumeData* pVolData = new SoVolumeData();
  pVolData->fileName =  "$OIVHOME/examples/data/VolumeViz/SYN_64.VOL";

  // Use a predefined colorMap
  // Set the first entry in the colormap to be transparent (alpha = 0)
  SoTransferFunction* pTransFunc = new SoTransferFunction;
  pTransFunc->predefColorMap = SoTransferFunction::BLUE_WHITE_RED;
  pTransFunc->actualColorMap.set1Value(3,0);

  // Display using volume rendering
  SoVolumeRender* pVolRender = new SoVolumeRender;

  // Assemble the volume rendering scene graph
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild( pVolData );
  root->addChild( pTransFunc );
  root->addChild( pVolRender );

  // Add the scene bounding box
  root->addChild( makeBBox( pVolData->extent.getValue() ) );

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Bounding Box");
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}


