/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
//
// Some routines I found generally useful
//

class SoInput;
class SoNode;
class SoSeparator;
class SoPath;

class Useful
{
  public:
    //
    // Read in a file.  These will all print an error message to
    // stderr and return NULL if there is an error.
    //
    static SoSeparator *readFile(const char *filename);
    static SoSeparator *readFile(FILE *fp);
    static SoSeparator *readFile(SoInput &in);

    //
    // Searches for and returns the last node of the given type on the
    // given path.  I use this to search for which material or
    // materialbinding or whatever affects a particular object in the
    // scene graph.  If ignore flags are set this will not necessarily
    // always be correct.
    //
    static SoNode *searchLastType(SoPath *, SoType);
};


