/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
//
// Convert from ASCII/binary Inventor file to a file suitable for 
// use as a compiled in variable.
//
// Format for these files is as follows:
//
// const char *variableName = { "0xXXXXX 0xXXXXX 0xXXXX" };
//
// where the stuff between the quotes is a hex version of the binary file.
//

#include <stdio.h>
#ifndef _WIN32
#include <unistd.h>
#endif
#include <string.h>
#include <assert.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInteraction.h>
//#include <Inventor/Xt/SoXt.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/SoInput.h>
#include <Inventor/SoOutput.h>
#include <Inventor/SoLists.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/helpers/SbFileHelper.h>

#ifdef _WIN32
#  define strdup _strdup
#endif

static void
print_usage(const char *progname)
{
  fprintf(stderr, "Usage: %s variableName < inputFile.iv\n", progname);
  fprintf(stderr, "   or: %s variableName inputFile\n", progname);
  fprintf(stderr, "variableName : The name of the variable to create.\n");
  exit(-1);
}

static void
parse_args(int argc, char **argv, char **variableName, char **fileName)
{
  if (argc < 2) {
    print_usage(argv[0]);
  }
  (*variableName) = strdup(argv[1]);
  if (argc > 2)
      (*fileName) = strdup(argv[2]);
  else
      (*fileName) = NULL;
  
  return; 
}

int 
main(int argc, char **argv)
{
  //SoXt::init(argv[0]);
  SoInteraction::init();

  // Parse arguments
  char *variableName = NULL;
  char *fileName     = NULL;
  parse_args(argc, argv, &variableName, &fileName);

  // read stuff:
  SoInput in;
  if (fileName) {
      if (! in.openFile( fileName )) {
          fprintf( stderr, "*** Unable to open '%s'\n", fileName );
          exit( -1 );
      }
  }
  else
    in.setFilePointer(stdin);
  SoSeparator *root = SoDB::readAll(&in);
  if (fileName)
    in.closeFile();

  if (root)
    root->ref();
  
  // write stuff into a buffer
  SoOutput out;
  out.setBinary(TRUE);
  out.setBuffer(malloc(1000), 1000, (void *(*)(void *, size_t))realloc);
  SoWriteAction writer(&out);
  writer.apply(root);

  if (root)
    root->unref();
  
  // Create the output file
  void *buf;
  size_t size;
  int ind;
  out.getBuffer(buf, size);
  unsigned char *outputBuffer = (unsigned char *) buf;
  {
    SbString baseProgName = SbFileHelper::getBaseName(argv[0]);
    SbString cleanupFilename;
	if (fileName)
		cleanupFilename = SbFileHelper::cleanUpPath(fileName);
    fprintf(stdout,"/* generated with cmd: %s %s %s */\n", baseProgName.toLatin1(), variableName, cleanupFilename.toLatin1());
  }
  fprintf(stdout, "const char %s[] = {\n", variableName);
  fprintf(stderr,"bufferSize = %llu\n", (unsigned long long)size);

  // All but last number get commas afterwards
  ind = 0;
  for (size_t j = 0; j < size-1; j++) {
    fprintf(stdout, "(char)0x%x,", outputBuffer[j]);
    if(ind == 14) {
      fprintf(stdout, "\n");
      ind = 0;
    }
    else
      ind++;
  }

  // Last number gets no comma afterwards
  fprintf(stdout, "0x%x,", outputBuffer[size-1]);
  fprintf(stdout, "\n};\n");
  
  return 0;
}


