/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
// Reads a binary-style variable from a buffer in another file
// and displays the result in a viewer.

//
// The file 'foo.h' contains a single variable called foo.
// This variable has been written out using the program
// ivToIncludeFile.
//
// For example, issuing the command:
// ivToIncludeFile foo < myFile.iv
//
// Will read in the file myFile.iv and write out a file called
// foo.h
// Inside foo.h will be the following:
// const char foo[] = { blah blah blah };
//
// Where 'blah blah blah' is a hex representation of the binary version of 
// the contents of myFile.iv
//
#include "foo.h"

#include <math.h>
#include <string.h>
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/SoXt.h>

SoNode *
readFromIncludeFile()
{
   SoInput in;

   SoSeparator *root = new SoSeparator;

   if (foo == NULL )
    return root;

    in.setBuffer((void *) foo, (size_t) sizeof(foo));

    SoNode *n;
    while ((SoDB::read( &in, n ) != FALSE) && (n != NULL))
	root->addChild(n);

    return root;
}

int 
main(int /*argc*/, char **argv)
{
   // Initialize Inventor and Xt
   Widget appWindow = SoXt::init(argv[0]);
   if (appWindow == NULL)
     exit(1);

   SoNode *root = readFromIncludeFile();
   root->ref();

   SoXtExaminerViewer *viewer = new SoXtExaminerViewer(appWindow);
   viewer->setSceneGraph( root );
   viewer->setTitle("testResult");
   viewer->show();
   viewer->viewAll();

   SoXt::show(appWindow);
   SoXt::mainLoop();

   delete viewer;
   SoXt::finish();

   return 0;
}


