/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
// #include <Inventor/nodes/SoLevelOfDetail.h>
#include <Inventor/nodes/SoLOD.h>
#include <Inventor/nodes/SoSeparator.h>

int
main(int argc, char *argv[])
{
    SbString filename = "$OIVHOME/examples/source/Inventor/lod/lod.iv";

    if (argc < 2) {
	fprintf(stderr, "NOTE: You can specify your own geometry file.\n");
	fprintf(stderr, "Run: %s inputFile.\n", argv[0]);
	fprintf(stderr, "Running with the default geometry, %s.\n", filename.toLatin1());
    } else {
	filename = argv[1];
    }

    // Initialize Inventor and Xt
    Widget mainWindow = SoXt::init(argv[0]);

    // Read the geometry from the file
    SoInput in;
    SoNode *fileGeom;
    if (! in.openFile(filename))
	exit(1);
    if(! SoDB::read(&in, fileGeom) || fileGeom == NULL)
	exit(1);

    // Create the root node and the empty LevelOfDetail node
    SoSeparator *root = new SoSeparator;
    root->ref();

    // Using the SoLOD node is the recommended way of doing
    // level-of-detail switching in Inventor 2.1 - it's faster
    // than the old SoLevelOfDetail
    SoLOD *lod = new SoLOD;
    root->addChild(lod);
    lod->range.set1Value(0, 25);
    lod->range.set1Value(1, 50);
    lod->range.set1Value(2, 100);
    lod->center.setValue(0,0,0);

    // Pre-2.1 programs must use the SoLevelOfDetail node
    // SoLevelOfDetail *lod = new SoLevelOfDetail;
    // root->addChild(lod);
    // lod->screenArea.set1Value(0, 110000.);
    // lod->screenArea.set1Value(1,  20000.);
    // lod->screenArea.set1Value(2,   3000.);
    // lod->screenArea.set1Value(3,   1000.);

    // Search for the different levels by name, and insert
    // into the level-of-detail group
    SoSeparator *level1 = (SoSeparator *)fileGeom->getByName("Level1");
    if (level1 != NULL &&
	level1->isOfType(SoSeparator::getClassTypeId())) {
	lod->addChild(level1);
    }

    SoSeparator *level2 = (SoSeparator *)fileGeom->getByName("Level2");
    if (level2 != NULL &&
	level2->isOfType(SoSeparator::getClassTypeId())) {
	lod->addChild(level2);
    }

    SoSeparator *level3 = (SoSeparator *)fileGeom->getByName("Level3");
    if (level3 != NULL &&
	level3->isOfType(SoSeparator::getClassTypeId())) {
	lod->addChild(level3);
    }

    SoSeparator *level4 = (SoSeparator *)fileGeom->getByName("Level4");
    if (level4 != NULL &&
	level4->isOfType(SoSeparator::getClassTypeId())) {
	lod->addChild(level4);
    }

    fprintf(stderr, "\nUse the left&middle mouse buttons to zoom\n");

    // Create the viewer
    SoXtExaminerViewer *viewer = new SoXtExaminerViewer(mainWindow);
    viewer->setDecoration(FALSE);
    viewer->setTitle("Details, details");
    viewer->setSceneGraph(root);
    viewer->show();

    // Loop forever
    SoXt::show(mainWindow);
    SoXt::mainLoop();
}


