/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
/*-------------------------------------------------------------
 *  This sample shows displaying Inventor viewers on different
 *  X displays.
 *------------------------------------------------------------*/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Label.h>
#include <stdio.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoCube.h>

int
main(int argc, char *argv[])
{
   Widget mainWindow = SoXt::init(argv[0]);
   XtAppContext appContext = SoXt::getAppContext();
   
   // Open another display
   Display *altDisplay = NULL;
   if (argc == 2) {
       printf("Opening display %s\n", argv[1]);
       altDisplay = XtOpenDisplay(
	  appContext, 
	  argv[1],     // display name
	  argv[0],     // application name
	  "Inventor",  // class name
	  NULL, 0, 
	  &argc, argv);
   }

   SoXtExaminerViewer *v1 = new SoXtExaminerViewer(mainWindow);
   v1->setSceneGraph(new SoCone);
   v1->show();	
   XtRealizeWidget(mainWindow);

   if (altDisplay != NULL) {
      Widget altWindow = XtAppCreateShell(
         argv[0],     // application name
	 "Inventor",  // class name
	 applicationShellWidgetClass, // widget class
	 altDisplay, 
	 NULL, 0);
      SoXtExaminerViewer *v2 = new SoXtExaminerViewer(altWindow);
      v2->setTitle("Examiner Viewer 2");
      v2->setSceneGraph(new SoCube);
      v2->show();		    
      XtRealizeWidget(altWindow);
   }
         
   SoXt::mainLoop();

   return 0;
}

