//
// PoView
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoSearchAction.h> 
#include <Inventor/Gui/view/PoView.h>

class PoXtExaminerViewer : public SoXtExaminerViewer 
{
public:
  PoXtExaminerViewer(Widget parent=NULL, const char *name=NULL,
		     SbBool buildInsideParent=TRUE, 
		     SoXtFullViewer::BuildFlag flag=BUILD_ALL,
		     SoXtViewer::Type type=BROWSER) ;

  void viewAll() ;
} ;

SoSeparator *scene1, *scene2 ;
PoView *view1, *view2;
PoXtExaminerViewer *myViewer ;

/*---------------------------------------------------------------------------*/

PoXtExaminerViewer::PoXtExaminerViewer(Widget parent, const char *name,
				       SbBool buildInsideParent, 
				       SoXtFullViewer::BuildFlag flag,
				       SoXtViewer::Type typeViewer) 
: SoXtExaminerViewer(parent, name, buildInsideParent, flag, typeViewer)
{
}/*---------------------------------------------------------------------------*/

void
PoXtExaminerViewer::viewAll()
{
  SoCamera* viewerCam = getCamera();

  SoSearchAction search1;
	search1.setNode(viewerCam);
	search1.apply(view1);
	
  SoSearchAction search2;
	search2.setNode(viewerCam);
	search2.apply(view2);
	
  if (search1.getPath() != NULL)
    viewerCam->viewAll(scene1, SbViewportRegion(100, 100)) ;
  else if (search2.getPath() != NULL)
    viewerCam->viewAll(scene2, SbViewportRegion(100, 100));

}/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   Widget myWindow = SoXt::init(argv[0]); 
   if (myWindow == NULL) exit(1);

   SoBaseKit::setSearchingChildren(TRUE) ;

   // Build the first view
   scene1 = new SoSeparator ;   
   SoMaterial *myMaterial = new SoMaterial;
   myMaterial->diffuseColor.setValue(0.0, 0.0, 1.0);
   scene1->addChild(myMaterial);
   scene1->addChild(new SoCube);

   view1 = new PoView() ;
   view1->sensitiveOnEvents(TRUE) ;
   view1->viewportOrigin.setValue(0., 0.) ;
   view1->viewportSize.setValue(0.5, 0.5) ;
   SoPerspectiveCamera* camera1 = new SoPerspectiveCamera ;
   view1->setPart("cameraKit.camera", camera1) ;

   // Build the second view
   scene2 = new SoSeparator ;
   SoMaterial *myMaterial2 = new SoMaterial;
   myMaterial2->diffuseColor.setValue(0.0, 1.0, 0.0);
   scene2->addChild(myMaterial2);
   scene2->addChild(new SoSphere);

   view2 = new PoView() ;
   view2->sensitiveOnEvents(TRUE) ;
   view2->viewportOrigin.setValue(0.5, 0.5) ;
   view2->viewportSize.setValue(0.5, 0.5) ;
   SoPerspectiveCamera* camera2 = new SoPerspectiveCamera ;
   view2->setPart("cameraKit.camera", camera2) ;

   // Build the entire graph
   SoSeparator *root = new SoSeparator ;
   root->ref();

   SoDirectionalLight *dirLight = new SoDirectionalLight ;
   dirLight->direction.setValue(0.2F, -0.2F, -1.0F) ;
   root->addChild(dirLight) ;

   root->addChild(view1) ;   
   root->addChild(scene1) ;
   root->addChild(view2) ;
   root->addChild(scene2) ;

   camera1->viewAll(scene1, SbViewportRegion(100, 100)) ;
   camera2->viewAll(scene2, SbViewportRegion(100, 100)) ;

   myViewer =  new PoXtExaminerViewer(myWindow);
   myViewer->setSceneGraph(root);
   myViewer->setHeadlight(FALSE) ;
   myViewer->setCamera(camera1) ;
   myViewer->setTitle("PoView");
   myViewer->show();
   
   SoXt::show(myWindow);
   SoXt::mainLoop();
   SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


