/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jean-Paul Digeon (Sep 2011)
** Modified by : Tristan Mehamli (Sep 2011)
**=======================================================================*/

#include <IvtMyFirstExtension.h>

#include <IvTune/IvTuneExtender/IvtShell.h>
#include <IvTune/IvTuneExtender/IvtProfileSetting.h>

#include <QTextEdit>

//------------------------------------------------------------------------------
IvtMyFirstExtension::IvtMyFirstExtension()
  :IvtExtension() , m_textEdit(0)
{
  // In the constructor complete the info structure inherited from IvtExtension
  m_info.name = "My First Extension";
  m_info.author ="Thermo Fisher Scientific";
  m_info.description = "The simplest IvTune extension sample.";
  m_info.version = "1.0.0";
}

//------------------------------------------------------------------------------
IvtMyFirstExtension::~IvtMyFirstExtension()
{
}

//------------------------------------------------------------------------------
void
IvtMyFirstExtension::activate()
{
  IvtProfileSetting*  p = getProfileSetting();
  SbString Message =  p->getParameter("Message");

  if (Message.isEmpty())  Message = "No Preference available!!";


  // Here is done all the registrations to GUI parts of IvTune and data process needed for the extension
  IvtShell::getInstance()->showStatusBarMessage( Message, 0 );
  IvtShell::getInstance()->registerPreferencePanel(this, m_textEdit , SLOT(s_init()), SLOT(s_accept()));
  IvtExtension::activate(); // Always call it last
}

//------------------------------------------------------------------------------
void
IvtMyFirstExtension::deactivate()
{
  // Here is done all the deregistrations and data cleaning
  IvtExtension::deactivate(); // Always call it first
  IvtShell::getInstance()->clearStatusBarMessage();
  IvtShell::getInstance()->unregisterPreferencePanel(this);
}

//------------------------------------------------------------------------------
void
IvtMyFirstExtension::hide()
{
  IvtExtension::hide(); // Always call it first
  //Your code
  // Everything which must be hidden is done here
}

//------------------------------------------------------------------------------
void 
IvtMyFirstExtension::load()
{	
  //Your code
  // Here is the initialization of the extension, object instantiation and so on
   m_textEdit = new QTextEdit(  );
}

//------------------------------------------------------------------------------
void 
IvtMyFirstExtension::show()
{
  IvtExtension::show(); // Always call it first
  //Your code
  // Everything which must be shown is done here
 
}

//------------------------------------------------------------------------------
void
IvtMyFirstExtension::unload()
{
  //Your code
  // Clean what was done in load()
  if (m_textEdit)
  {
    delete m_textEdit;
    m_textEdit = 0;
  }
}

//------------------------------------------------------------------------------
void  
  IvtMyFirstExtension::s_init(  )
{
  IvtProfileSetting*  p = getProfileSetting();
  SbString Message =  p->getParameter("Message");

  if (Message.isEmpty())  Message = "No Preference available!!";

  m_textEdit->setPlainText(Message.toLatin1());
}

//------------------------------------------------------------------------------
void  
  IvtMyFirstExtension::s_accept()
{
  IvtProfileSetting*  p = getProfileSetting();
  SbString Message = m_textEdit->toPlainText().toLatin1().data();
  p->setParameter("Message", Message);

  if (isActive())
      IvtShell::getInstance()->showStatusBarMessage( Message, 0 );
}


