/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jean-Paul Digeon (Sep 2011)
** Modified by : Tristan Mehamli (Sep 2011)
**=======================================================================*/

#include <IvtMySecondExtension.h>

#include <IvTune/IvTuneExtender/IvtShell.h>
#include <IvTune/IvTuneExtender/IvtPluginsManager.h>
#include <IvTune/IvTuneExtender/IvtProfile.h>

#include <QToolBar>
#include <QComboBox>

//------------------------------------------------------------------------------
IvtMySecondExtension::IvtMySecondExtension()
  :IvtExtension()
{
  // In the constructor complete the info structure inherited from IvtExtension
  m_info.name = "My Second Extension";
  m_info.author ="Thermo Fisher Scientific";
  m_info.description = "A sample";
  m_info.version = "1.0.0";
}

//------------------------------------------------------------------------------
IvtMySecondExtension::~IvtMySecondExtension()
{
}

//------------------------------------------------------------------------------
void
IvtMySecondExtension::activate()
{
  // Here is done all the registrations to GUI parts of IvTune and data process needed for the extension
  // Procession of profiles added to the combo box of this extension
  const std::list<IvtProfile*>&  profiles = IvtPluginsManager::getInstance()->getProfilesList();
  IvtProfile* activeProfile = IvtPluginsManager::getInstance()->getActiveProfile();
  std::list<IvtProfile*>::const_iterator it;
  m_profileCombo->clear();
  int activeProfileIndex = -1;

  int i;
  for ( i = 0, it = profiles.begin(); it != profiles.end(); it++, i++ )
  {
    m_profileCombo->addItem( (*it)->getName().toLatin1() );
    if ( activeProfile == (*it) )
      activeProfileIndex = i;
  }
  m_profileCombo->setCurrentIndex( activeProfileIndex );
  // Signal / slot connection
  connect( m_profileCombo, SIGNAL(currentIndexChanged(int)), SLOT(s_currentIndexChanged(int)) );
  // GUI registration
  IvtShell::getInstance()->registerToolBar( m_toolbar );
  IvtShell::getInstance()->registerViewMenu( this );
  // The extension is set up so show it
  show();
  IvtExtension::activate();
}

//------------------------------------------------------------------------------
void
IvtMySecondExtension::deactivate()
{
  // Here is done all the deregistrations and data cleaning
  IvtExtension::deactivate();
  // Signal / slot disconnection
  QObject::disconnect( m_profileCombo, SIGNAL(currentIndexChanged(int)), this, SLOT(s_currentIndexChanged(int)) );
  // GUI deregistration
  IvtShell::getInstance()->unregisterToolBar( m_toolbar );
  IvtShell::getInstance()->unregisterViewMenu( this );
}

//------------------------------------------------------------------------------
void
IvtMySecondExtension::hide()
{
  IvtExtension::hide();
  m_toolbar->hide(); // Hide the GUI elements of this extension
}

//------------------------------------------------------------------------------
void 
IvtMySecondExtension::load()
{
  // Instantiation of the GUI elements of this extension
  m_toolbar = new QToolBar();
  m_profileCombo = new QComboBox( m_toolbar );
  // GUI set up
  m_profileCombo->setToolTip( "Select the active profile." );
  m_toolbar->addWidget( m_profileCombo );
}


//------------------------------------------------------------------------------
void  
IvtMySecondExtension::s_currentIndexChanged( int index )
{
  const std::list<IvtProfile*>&  profiles =  IvtPluginsManager::getInstance()->getProfilesList();
  std::list<IvtProfile*>::const_iterator it;

  int i;
  for (  i = 0, it = profiles.begin(); it != profiles.end(); it++, i++ )
  {
    m_profileCombo->addItem( (*it)->getName().toLatin1() );
    if ( index == i )
    {
      IvtPluginsManager::getInstance()->setActiveProfile( (*it) );
      return;
    }
  }
}

//------------------------------------------------------------------------------
void 
IvtMySecondExtension::show()
{
  IvtExtension::show();
  m_toolbar->show(); // Show the GUI elements of this extension
}

//------------------------------------------------------------------------------
void
IvtMySecondExtension::unload()
{
  // Clean instanced GUI elements of this extension
  delete m_profileCombo;
  delete m_toolbar;
}


