#include <Inventor/sys/port.h>

#include <LDM/nodes/SoDataCompositor.h>
#include <Inventor/fields/SoSFBool.h>


// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_DLL is defined in the node's source file.
#ifdef BUILDING_DLL
  #define DLL_EXPORT VC_DLL_EXPORT
#else
  #define DLL_EXPORT VC_DLL_IMPORT
#endif


////////////////////////////////////////////////////////////////////////
//
// Define custom data compositor class
////////////////////////////////////////////////////////////////////////

class DLL_EXPORT MedicalCPUDataCompositor : public SoDataCompositor
{
  SO_NODE_HEADER( MedicalCPUDataCompositor );

public:

  // Constructor
  MedicalCPUDataCompositor();

  // Destructor
  virtual ~MedicalCPUDataCompositor();

  static void initClass();
  static void exitClass();

  // Override compose method from SoDataCompositor ( converted input version)
  // WARNING : all input have the same data type
  virtual void compose(int numVolumeData, const SbVec3i32& tileDimension,
               int* vdid, SoBufferObject** inputBuffer, SoBufferObject* outputBuffer);

  // Override compose method from SoDataCompositor ( not converted input version)
  // WARNING: This demo do not implement this mode
  virtual void compose(int numDataSet, const SbVec3i32& tileDimension,
               int* vdid, SoBufferObject** inputBuffer, SoDataCompositor::DataType* dataTypes,
               SoBufferObject* outputBuffer);

private:

  // RGBA Mode composition
  void composeRGBAInCPU( int numVolumeData, const SbVec3i32& tileDimension,
    int* vdid, SoBufferObject** inputBufferObject, SoBufferObject* outputBufferObject );

  // INDEXED Mode CPU implementation
  void composeInCPU(int numVolumeData, const SbVec3i32& tileDimension,
    int* vdid, SoBufferObject** inputBuffer, SoBufferObject* outputBuffer);

};

