///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

//!oiv_include <VolumeViz/vvizGetData_frag.h>

uniform VVizDataSetId data1;
uniform VVizDataSetId data2;

VVIZ_DATATYPE VVizCombineData(vec3 texCoord)
{
  VVIZ_DATATYPE index1 = VVizGetData(data1, texCoord);
  VVIZ_DATATYPE index2 = VVizGetData(data2, texCoord);

  if (index2 == VVIZ_DATATYPE(0.))
    return VVIZ_DATATYPE(0.);

  return index1;
}
