///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

uniform VVizDataSetId data1;
uniform VVizDataSetId data2;

vec4 VVizComputeFragmentColor(VVizDataSetId data, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int maskId)
{
  vec3 texCoord = voxelInfoFront.texCoord;

  //texture unit 1 -> data 1
  VVIZ_DATATYPE index1 = VVizGetData(data1, texCoord);
  //Use transfer function 0
  vec4 color1 = VVizTransferFunction(index1, 0);

  //texture unit 2 -> data 2
  VVIZ_DATATYPE index2 = VVizGetData(data2, texCoord);
  //Use transfer function 1
  vec4 color2 = VVizTransferFunction(index2, 1);

  if(color1.a != 0.)
    color1.a = color2.a;

  return color1;
}
