#include "MyRenderAreaInteractive.h"

#include <Inventor/ViewerComponents/nodes/SceneInteractor.h>
#include <Inventor/SoSceneManager.h>
#include <Inventor/nodes/SoStereoCamera.h>

void
MyRenderAreaInteractive::setSceneGraph( SoSeparator* sceneGraph )
{
  m_rootSceneGraph = sceneGraph;
  RenderArea::setSceneGraph( sceneGraph );
}

void
MyRenderAreaInteractive::addSceneInteractor( SceneInteractor* sceneInteractor )
{
  m_sceneInteractors.push_back( sceneInteractor );
}

//------------------------------------------------------------------------------
void
MyRenderAreaInteractive::viewAll( const SbViewportRegion &viewport )
{
  for ( std::vector<SceneInteractor*>::iterator it = m_sceneInteractors.begin(); it != m_sceneInteractors.end(); ++it )
    (*it)->viewAll( viewport );
}

void
MyRenderAreaInteractive::viewAxis( const SbVec3f& direction, const SbVec3f& up )
{
  for ( std::vector<SceneInteractor*>::iterator it = m_sceneInteractors.begin(); it != m_sceneInteractors.end(); ++it )
    (*it)->viewAxis( direction, up );
}

bool
MyRenderAreaInteractive::isStereoSupported() const
{
  return false;
}

//------------------------------------------------------------------------------
SoRenderAreaCore::RenderStatus
MyRenderAreaInteractive::render()
{
  SoRenderAreaCore::RenderStatus status = RenderArea::render();

  if ( status == SoRenderAreaCore::ABORTED )
    return SoRenderAreaCore::ABORTED;

  if ( getClippingPlanesAdjustMode() == AUTO )
  {
    // Update camera clipping planes before each rendering.
    for ( std::vector<SceneInteractor*>::iterator it = m_sceneInteractors.begin(); it != m_sceneInteractors.end(); ++it )
      (*it)->adjustClippingPlanes( m_renderAreaCore->getSceneManager()->getViewportRegion() );
  }

  // render scene
  return status;
}
