#ifndef _MyRenderAreaInteractive_
#define _MyRenderAreaInteractive_

#include <Inventor/ViewerComponents/Qt/RenderAreaInteractive.h>

// RenderAreaInteractive with management of 4 SceneInteractors
class MyRenderAreaInteractive : public RenderAreaInteractive
{
public :

  MyRenderAreaInteractive( QWidget* parent = NULL ) : RenderAreaInteractive( parent, false ) {}

  /**
   * Add a scene interactor to the list of scene interactors used by this render area.
   */
  void addSceneInteractor( SceneInteractor* sceneInteractor );

  /**
   * Override setSceneGraph of RenderAreaInteractive to avoid construction of SceneInteractor root node.
   */
  virtual void setSceneGraph( SoSeparator* sceneGraph );

  /**
   * Override getRootSceneGraph of SoRenderAreaInteractive to return a SoSeparator instead of a SceneInteractor.
   */
  SoSeparator* getRootSceneGraph() const { return m_rootSceneGraph; }

  /**
   * Perform a viewAll on each SceneInteractor.
   */
  virtual void viewAll( const SbViewportRegion &viewport );

  /**
  * Perform a viewAxis on each SceneInteractor.
  */
  virtual void viewAxis( const SbVec3f& direction, const SbVec3f& up );

  /*
  * Returns false because this demo don't use stereo capabilities.
  */
 virtual bool isStereoSupported() const;

protected :

  virtual SoRenderAreaCore::RenderStatus render();

  std::vector<SceneInteractor*> m_sceneInteractors;

  SoSeparator* m_rootSceneGraph;
};

#endif // _MyRenderAreaInteractive_
