///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

#if !defined(OGL_WINDOW_H)
#define OGL_WINDOW_H

class OGLWindowImpl;

enum SimpleKeyCode
{
  KEY_LEFT,
  KEY_RIGHT,
  KEY_UP,
  KEY_DOWN,
  KEY_SPACE,
  KEY_J,
  KEY_P,
  KEY_I
};

typedef void (*DrawCB)(void);

typedef void (*KeyCB)(const SimpleKeyCode);

class OGLWindow
{
public:
  OGLWindow(int width, int height);

  ~OGLWindow();

  void render();

  void mainLoop();

  void setDrawCallback(DrawCB callback);
  
  void setKeyCallback(KeyCB callback);

  void bindContext();
  
  void unbindContext();

  void update();
private:

  OGLWindowImpl* m_impl;
};

#endif // OGL_WINDOW_H
