///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

// variable used in medicalCutting code to change the position of the cutting simulation.
uniform float cuttingPosition;

vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
  vec3 texCoord = voxelInfoFront.texCoord;

  float x = texCoord.x;
  float fx = -16 * pow(x, 5) + 40 * pow(x, 4) - 32 * pow(x, 3) + 8 * pow(x, 2) + x;

  float elevation = texCoord.y * texCoord.y * texCoord.y;
  elevation = 1 - elevation;
  if ( elevation < 1.0 - 0.1*cuttingPosition )
    elevation = 0.0;
  else
    elevation -= 1.0 - 0.1*cuttingPosition;

  texCoord.x = mix(x, fx, elevation );

  float alpha = 0.15;
  if ( abs(x - 0.5) < mix(0.0, alpha, elevation ) )
    return vec4(0.0);

  // get the data value at this position
  VVIZ_DATATYPE sf = VVizGetData(dataset, texCoord);
  // get the color for this value through the transfer function
  vec4 res = VVizTransferFunction(sf, 0);
  
  return res;
}

