///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////
/*=======================================================================
** Updaded by Pascal Estrade (Sep 2014)
**=======================================================================*/
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoText2.h>

#include <VolumeViz/nodes/SoVolumeData.h>

#include <Medical/InventorMedical.h>
#include <Medical/helpers/MedicalHelper.h>
#include <Medical/nodes/Gnomon.h>

///////////////////////////////////////////////////////////////////////////////

#define FILENAME "$OIVHOME/examples/source/Medical/Rendering/Techniques/medicalDeferredLighting/medicalDeferredLighting.iv"

///////////////////////////////////////////////////////////////////////////////
//main function
int main(int /*argc*/, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();
  InventorMedical::init();

  SoRef<SoSeparator> root = new SoSeparator;

  // Perspective camera to view the scene 
  SoPerspectiveCamera* camera = new SoPerspectiveCamera();
    root->addChild( camera );

  SoSeparator* scene = MedicalHelper::readFile(FILENAME);
  if (!scene) {
    // Display error message
    scene = new SoSeparator();
    SoFont* font = new SoFont();
      font->size = 24;
      scene->addChild( font );
    SoText2* text = new SoText2();
      text->string = "Unable to open file";
      scene->addChild( text );
  }
  root->addChild(scene);

  // Define OIV logo and orientation marker
  root->addChild( MedicalHelper::exampleLogoNode() );
  root->addChild( new Gnomon() );

  // Set up viewer:
  SoXtExaminerViewer* viewer = new SoXtExaminerViewer(myWindow);
  viewer->setTransparencyType(SoGLRenderAction::NO_SORT);
  viewer->setTitle("With and Without Deferred Lighting");
  viewer->setSize( MedicalHelper::exampleWindowSize() );
  viewer->setDecoration( FALSE );
  viewer->setSceneGraph(root.ptr());

  // Adjust camera
  MedicalHelper::orientView(MedicalHelper::CORONAL, camera );
  viewer->viewAll();
  MedicalHelper::dollyZoom( 1.5f, camera ); // Fill viewport
  viewer->saveHomePosition();
  viewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete viewer;

  root = NULL;

  InventorMedical::finish();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}


