///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

//!oiv_include <VolumeViz/vvizfnc_frag.h>

uniform float gamma;

vec4 applyGamma(vec4 color)
{
  vec4 outColor = color;
  outColor.xyz = pow(color.xyz, vec3(1/gamma));
  return outColor;
}

// shader for slices
vec4 VVizComputeFragmentColor(VVIZ_DATATYPE vox, vec3 texCoord)
{
  // Apply colormap and other effects to data
  vec4 colorVolume = VVizComputeVolumeRendering(vox);
  
  colorVolume = applyGamma(colorVolume);

  // return the final color
  return colorVolume;
}

// shader for VolumeRender
vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
  // Apply colormap and other effects to data
  vec4 colorVolume = VVizComputeVolumeRendering(voxelInfoFront.value);
  
  colorVolume = applyGamma(colorVolume);

  // return the final color
  return colorVolume;
}

