///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

/*----------------------------------------------------------------------------------------
Medical example program.
Description : Manage events for this demonstration.
----------------------------------------------------------------------------------------*/

#include <VolumeViz/nodes/SoObliqueSlice.h>
#include <Inventor/Gui/view/PoView.h>
#include <VolumeViz/nodes/SoOrthoSlice.h>

class SoEventCallback;
class SoJackDragger;
class SoSensor;

const int NUM_I = 4;
const int NUM_J = 6;

struct dataEvent {
    SoOrthoSlice* OrthoSlice_Z[NUM_I][NUM_J];
	PoView*       view[NUM_I][NUM_J];
	SoSeparator*  sep;
};

void keyboardPressCB(void *userData, SoEventCallback *eventCB);

// Get mouse move events.
void mouseMoveEventCB(void *userData, SoEventCallback *eventCB);

// Get mouse button events.
void mouseButtonEventCB(void *userData, SoEventCallback *eventCB);

// Get key events.
void keyboardPressCB(void *userData, SoEventCallback *eventCB);

// Manipulate Oblique Slice and clipping plane.
void motionObliSliceCallback(void *user_data, SoJackDragger *dragger);

// Change camera in Oblique Viewer. This to be always in front of the oblique slice.
void obliqueRotationFieldSensorCB( void *userData, SoSensor *s);
